/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.time;

import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.generator.time.IReleaseConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.IStreamConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.ReleasePersistency;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.rest.entities.releases.RestStream;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StreamPersistency {
    private final PortfolioStreamPersistence streamPersistence;
    private final ReleasePersistency releasePersistency;

    StreamPersistency(PortfolioStreamPersistence streamPersistence, ReleasePersistency releasePersistency) {
        this.streamPersistence = streamPersistence;
        this.releasePersistency = releasePersistency;
    }

    public StreamPersistency(PortfolioStreamPersistence streamPersistence, PortfolioReleasePersistence releasePersistence) {
        this.streamPersistence = streamPersistence;
        this.releasePersistency = new ReleasePersistency(releasePersistence);
    }

    public IStream persistReleaseStream(IStreamConfiguration configuration, int index, IPlan plan) throws PersistenceException {
        RestStream stream = new RestStream(null, null, null);
        String title = configuration.getTitle();
        stream.setTitle(title);
        stream.setSortOrder(Long.valueOf(index));
        stream.setPlan(plan);
        IStream persistedStream = this.streamPersistence.persist(stream);
        List<IReleaseConfiguration> releaseConfigurations = configuration.getReleaseConfigurations();
        for (int releaseIndex = 0; releaseIndex < releaseConfigurations.size(); ++releaseIndex) {
            this.releasePersistency.persistRelease(releaseConfigurations.get(releaseIndex), persistedStream, releaseIndex, plan);
        }
        return persistedStream;
    }
}

