/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.AOCustomWording;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IInsert;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ICustomTransaction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CustomWordingStoreSQL
extends BaseTransactionalAOPersistenceSQL {
    public CustomWordingStoreSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public void store(final String key, final String value) throws SQLException {
        this.inCustomTransaction(new ICustomTransaction<Void>(){

            @Override
            public Void execute(Connection connection) throws SQLException {
                final String id = (String)CustomWordingStoreSQL.this.sql(new IQuery<String>(){

                    @Override
                    public void sql(AOQueryGenerator generator) throws Exception {
                        generator.withTable(AOCustomWording.class, "w").select().colId("w").from("w").where().col("w", "wordKey").eq().str(key);
                    }

                    @Override
                    public String handleResult(ResultSet result) throws Exception {
                        if (result.next()) {
                            return BaseAOPersistenceSQL.getString(result, 1);
                        }
                        return null;
                    }
                }, connection, false);
                if (id == null) {
                    CustomWordingStoreSQL.this.sql(new IInsert(){

                        @Override
                        public void sql(AOQueryGenerator generator) throws Exception {
                            generator.withTable(AOCustomWording.class, "w").insert().tableNoAlias("w").raw("(").colNoAlias("w", "wordKey").colNoAlias("w", "wordValue").raw(") VALUES (").str(key).raw(",").str(value).raw(")");
                        }

                        @Override
                        public void handleResult(String newId) throws Exception {
                        }
                    }, connection, false);
                } else {
                    CustomWordingStoreSQL.this.sql(new IUpdate(){

                        @Override
                        public void sql(AOQueryGenerator generator) throws Exception {
                            generator.withTable(AOCustomWording.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "wordValue").eq().str(value).where().colIdNoAlias("w").eq().numeric(id);
                        }
                    }, connection, false);
                }
                return null;
            }
        });
    }
}

