/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.IAbility;
import com.radiantminds.roadmap.common.data.entities.people.IAbsence;
import com.radiantminds.roadmap.common.data.entities.people.IPresence;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiableImpl;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import java.util.List;

public class AOPersonImpl
extends AOIdentifiableImpl {
    private final AOPerson person;

    public AOPersonImpl(AOPerson person) {
        super(person);
        this.person = person;
    }

    public List<IAbility> getAbilities() {
        return Lists.newArrayList((Object[])this.person.getAOAbilities());
    }

    public List<IResource> getResources() {
        return Lists.newArrayList((Object[])this.person.getAOResources());
    }

    public Optional<IAbility> getAbilityForSkill(String skillId) {
        for (AOAbility ability : this.person.getAOAbilities()) {
            if (!ability.getTargetType().equals("skill") || !skillId.equals(ability.getTargetId().toString())) continue;
            return Optional.fromNullable((Object)ability);
        }
        return Optional.absent();
    }

    public Optional<IAbility> getAbilityForStage(String stageId) {
        for (AOAbility ability : this.person.getAOAbilities()) {
            if (!ability.getTargetType().equals("stage") || !stageId.equals(ability.getTargetId().toString())) continue;
            return Optional.fromNullable((Object)ability);
        }
        return Optional.absent();
    }

    public Optional<String> getExternalId() {
        return Optional.fromNullable((Object)this.person.getAOExternalId());
    }

    public void setExternalId(String id) {
        this.person.setAOExternalId(id);
    }

    public List<IPresence> getPresenceIntervals() {
        return Lists.newArrayList((Object[])this.person.getAOPresenceIntervals());
    }

    public List<IAbsence> getAbsenceIntervals() {
        return Lists.newArrayList((Object[])this.person.getAOAbsenceIntervals());
    }

    public IPlan getPlan() {
        return this.person.getAOPlan();
    }

    public void setPlan(IPlan plan) {
        this.setExplicitRelation(plan, AOPlan.class, new AOIdentifiableImpl.IRelationCallback<AOPlan>(){

            @Override
            public void apply(AOPlan relation) {
                AOPersonImpl.this.person.setAOPlan(relation);
            }
        });
    }
}

