/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemType;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.AOExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemsWithTypeQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.SyncInformation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkItemSelectSQL
extends BaseAOPersistenceSQL {
    public WorkItemSelectSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public Map<String, Long> getEpicsSortOrder(final String planId, final boolean excludeDone) throws Exception {
        return this.sql(new IQuery<Map<String, Long>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                String epic = "epic";
                String story = "story";
                generator.withTable(AOWorkItem.class, story).withTable(AOWorkItem.class, epic).select().quoted("EPICID").from(new String[0]).raw("(").select().col(epic, "ID_OTHER", false).raw("AS").quoted("EPICID").raw(",").col(epic, "sortOrder").raw("AS").quoted("EPICSORTORDER").raw(",").raw("MIN(").col(story, "sortOrder").raw(")").raw("AS").quoted("MINSTORYSORTORDER").from(epic).leftJoin().table(story).on().col(story, "aoparent").eq().col(epic, "ID_OTHER", false).where().col(epic, "type").eq().numeric(WorkItems.Types.EPIC).and().col(epic, "aoplan").eq().numeric(planId);
                if (excludeDone) {
                    generator.and().raw("(").col(story, "status").isNull().or().col(story, "status").neq().numeric(WorkItemStatus.COMPLETED.value()).raw(")").and().raw("(").col(epic, "status").isNull().or().col(epic, "status").neq().numeric(WorkItemStatus.COMPLETED.value()).raw(")");
                }
                generator.groupBy().colId(epic).raw(",").col(epic, "sortOrder").raw(")").quoted("INNER").orderBy().raw("COALESCE(").quoted("EPICSORTORDER").raw(",").quoted("MINSTORYSORTORDER").raw(")");
            }

            @Override
            public Map<String, Long> handleResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                long order = 0L;
                while (result.next()) {
                    String epicId = BaseAOPersistenceSQL.getString(result, 1);
                    retVal.put(epicId, order);
                    ++order;
                }
                return retVal;
            }
        });
    }

    public boolean isDirectChildOf(String item, String potentialParent, Connection connection) throws SQLException {
        return this.sql(this.isDirectChildOfQuery(item, potentialParent), connection, false);
    }

    private IQuery<Boolean> isDirectChildOfQuery(final String item, final String potentialParent) {
        return new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "t").select().col("t", "aoParent").from("t").where().colId("t").eq().numeric(item);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                return result.next() && potentialParent.equals(BaseAOPersistenceSQL.getString(result, 1));
            }
        };
    }

    private IQuery<List<String>> getChildrenQuery(final String workItemId) throws SQLException {
        return new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "t").select().col("t", "ID_OTHER", false).from("t").where().col("t", "aoparent").eq().numeric(workItemId).orderBy().col("t", "sortOrder");
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return retVal;
            }
        };
    }

    public List<String> getChildrenInCustomTransaction(String workItemId, Connection connection) throws SQLException {
        return this.sql(this.getChildrenQuery(workItemId), connection, false);
    }

    public int countChildren(final String workItemId) throws SQLException {
        return this.sql(new IQuery<Integer>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").select().raw("COUNT(*)").from("w").where().col("w", "aoparent").eq().numeric(workItemId);
            }

            @Override
            public Integer handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getInt(result, 1);
                }
                return 0;
            }
        });
    }

    public String getParentId(final String id) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").select().col("w", "aoParent").from("w").where().colId("w").eq().numeric(id);
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        });
    }

    public Integer getWorkItemType(final String id) throws SQLException {
        return this.sql(new IQuery<Integer>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").select().col("w", "type").from("w").where().colId("w").eq().numeric(id);
            }

            @Override
            public Integer handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getInt(result, 1);
                }
                return null;
            }
        });
    }

    public List<IWorkItem> listWorkItemDescriptionsWithType(String planId, int type, boolean includeDone) throws SQLException {
        return this.sql(WorkItemsWithTypeQuery.create(planId, type, includeDone));
    }

    public Map<String, SyncInformation> getSyncInformation(final Collection<String> workItemIDs, final Collection<String> acceptedWorkItemTypes) throws SQLException {
        if (workItemIDs.isEmpty() || acceptedWorkItemTypes.isEmpty()) {
            return Maps.newHashMap();
        }
        return this.sql(new IQuery<Map<String, SyncInformation>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "link").withTable(AOWorkItem.class, "item").select().colId("item").col("item", "type").col("link", "extensionKey").col("link", "extensionLink").from("link").leftJoin().table("item").on().col("link", "aoExtendable").eq().colId("item").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("item");
                    }
                }, workItemIDs).and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col("item", "type");
                    }
                }, acceptedWorkItemTypes);
            }

            @Override
            public Map<String, SyncInformation> handleResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                while (result.next()) {
                    String itemId = BaseAOPersistenceSQL.getString(result, 1);
                    Integer itemType = WorkItemSelectSQL.getInteger(result, 2);
                    String extensionKey = BaseAOPersistenceSQL.getString(result, 3);
                    String extensionLink = BaseAOPersistenceSQL.getString(result, 4);
                    SyncInformation syncInformation = (SyncInformation)retVal.get(itemId);
                    if (syncInformation == null) {
                        syncInformation = new SyncInformation(WorkItemType.fromCode(itemType));
                        retVal.put(itemId, syncInformation);
                    }
                    ExtensionLink link = new ExtensionLink();
                    link.setExtensionKey(extensionKey);
                    link.setExtensionLink(extensionLink);
                    syncInformation.addExtensionLink(link);
                }
                return retVal;
            }
        });
    }
}

