/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IdMapper;
import com.radiantminds.roadmap.common.data.persistence.ao.port.MethodXmlConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TranslationException;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DbEntityTranslator {
    private static final Log LOGGER = Log.with(DbEntityTranslator.class);
    private final Map<Integer, MethodXmlConfiguration> columnConfigurations = Maps.newHashMap();
    private final Map<Integer, XmlType> columnTypes = Maps.newHashMap();
    private final int columnCount;

    public DbEntityTranslator(ResultSetMetaData metaData, Map<String, MethodXmlConfiguration> methodMap) throws SQLException, TranslationException {
        this.columnCount = metaData.getColumnCount();
        for (int i = 1; i <= this.columnCount; ++i) {
            String columnName = metaData.getColumnName(i).toLowerCase();
            if (!methodMap.containsKey(columnName)) {
                LOGGER.warn("Unknown column name '" + columnName + "'. No mapping found on AO entity.", new Object[0]);
                continue;
            }
            this.columnConfigurations.put(i, methodMap.get(columnName));
            MethodXmlConfiguration config = this.columnConfigurations.get(i);
            if (config.isPrimaryKey() || config.isForeignKey()) {
                this.columnTypes.put(i, XmlType.Attribute);
                continue;
            }
            Class<?> returnType = config.getReturnType();
            if (returnType == Integer.class || returnType == Integer.TYPE || returnType == Long.class || returnType == Long.TYPE) {
                this.columnTypes.put(i, XmlType.Attribute);
                continue;
            }
            if (returnType == Boolean.class || returnType == Boolean.TYPE) {
                this.columnTypes.put(i, XmlType.Boolean);
                continue;
            }
            if (returnType == Double.class || returnType == Double.TYPE) {
                this.columnTypes.put(i, XmlType.Double);
                continue;
            }
            this.columnTypes.put(i, XmlType.CDATA);
        }
    }

    public void translateRowIntoElement(ResultSet result, Document doc, Element itemElement, IdMapper idMapper, boolean anonymise) throws SQLException {
        String columnName;
        int i;
        HashMap values = Maps.newHashMap();
        HashMap types = Maps.newHashMap();
        for (i = 1; i <= this.columnCount; ++i) {
            MethodXmlConfiguration config = this.columnConfigurations.get(i);
            if (config == null) continue;
            columnName = config.getName();
            String content = null;
            if (this.columnTypes.get(i) == XmlType.Boolean) {
                Boolean booleanContent = BaseAOPersistenceSQL.getBoolean(result, i);
                if (booleanContent != null) {
                    content = String.valueOf(booleanContent);
                }
            } else if (this.columnTypes.get(i) == XmlType.Double) {
                Double doubleContent = BaseAOPersistenceSQL.getDouble(result, i);
                if (doubleContent != null) {
                    content = String.valueOf(doubleContent);
                }
            } else {
                content = BaseAOPersistenceSQL.getString(result, i);
            }
            if (content == null || content.length() <= 0) continue;
            values.put(columnName, content);
            types.put(columnName, this.columnTypes.get(i));
        }
        if (anonymise) {
            ImmutableMap originalValues = ImmutableMap.copyOf((Map)values);
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                String columnName2;
                String content;
                MethodXmlConfiguration config = this.columnConfigurations.get(i2);
                if (config == null || (content = (String)values.get(columnName2 = config.getName())) == null || config.getAnonymisationProvider() == null) continue;
                content = config.getAnonymisationProvider().anonymise((Map<String, String>)originalValues);
                if (content != null) {
                    values.put(columnName2, content);
                    continue;
                }
                values.remove(columnName2);
            }
        }
        for (i = 1; i <= this.columnCount; ++i) {
            Class<?> foreignKeyRelationship;
            MethodXmlConfiguration config = this.columnConfigurations.get(i);
            if (config == null) continue;
            columnName = config.getName();
            IKeyResolver resolver = config.getResolver();
            if (!values.containsKey(columnName) || resolver == null) continue;
            String dependsOn = config.getDependsOn();
            String dependencyValue = null;
            if (dependsOn != null) {
                dependencyValue = (String)values.get(dependsOn);
                foreignKeyRelationship = resolver.resolve(dependencyValue);
            } else {
                foreignKeyRelationship = resolver.resolve(null);
            }
            if (foreignKeyRelationship == null) continue;
            String prefix = resolver.getPrefix(dependencyValue);
            String value = (String)values.get(columnName);
            if (prefix != null) {
                value = value.substring(prefix.length());
            }
            value = idMapper.getMappedId(foreignKeyRelationship, value);
            if (prefix != null) {
                value = prefix + value;
            }
            values.put(columnName, value);
        }
        for (Map.Entry entry : values.entrySet()) {
            Element colElement;
            XmlType type = (XmlType)((Object)types.get(entry.getKey()));
            if (type == XmlType.CDATA) {
                colElement = doc.createElement((String)entry.getKey());
                String value = (String)entry.getValue();
                if (value.contains("<![CDATA[")) {
                    colElement.setAttribute("encoding", "base64");
                    value = Base64.encodeBase64String(value.getBytes());
                }
                colElement.appendChild(doc.createCDATASection(value));
                itemElement.appendChild(colElement);
                continue;
            }
            if (type == XmlType.Element || type == XmlType.Double) {
                colElement = doc.createElement((String)entry.getKey());
                colElement.appendChild(doc.createTextNode((String)entry.getValue()));
                itemElement.appendChild(colElement);
                continue;
            }
            itemElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static enum XmlType {
        CDATA,
        Element,
        Double,
        Attribute,
        Boolean;

    }
}

