/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsAccessor;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntities;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.UpgradePersistenceIndex;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class BaseUpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final Log LOGGER = Log.with(BaseUpgradeTask.class);

    protected abstract int getDataModelVersion();

    protected abstract void performUpgrade(ActiveObjectsUtilities var1, PersistenceIndex var2) throws Exception;

    protected boolean migrateOnUpgrade() {
        return false;
    }

    public Connection getOrCreateConnection(ActiveObjectsAccessor accessor) throws SQLException {
        return accessor.getEntityManager().getProvider().getConnection();
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)String.valueOf(this.getDataModelVersion()));
    }

    public void upgrade(ActiveObjectsUtilities activeObjectsUtilities, PersistenceIndex persistenceIndex) throws Exception {
        try {
            if (this.migrateOnUpgrade()) {
                activeObjectsUtilities.getAccessor().getEntityManager().migrate((Class[])AOEntities.getEntityTypesAsArray());
            }
            this.performUpgrade(activeObjectsUtilities, persistenceIndex);
            LOGGER.info("[Upgrade task to data model version " + this.getDataModelVersion() + "]\tSuccessfully executed.", new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.info("[Upgrade task to data model version " + this.getDataModelVersion() + "]\tFailed to migrate.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.INFO);
            throw ex;
        }
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        LOGGER.info("[Upgrade task to data model version " + this.getDataModelVersion() + "]...", new Object[0]);
        if (currentVersion.isOlderThan(this.getModelVersion())) {
            try {
                UpgradePersistenceIndex persistenceIndex = new UpgradePersistenceIndex(ao);
                ActiveObjectsUtilities activeObjectsUtilities = persistenceIndex.getPersistenceUtilityBean();
                if (this.migrateOnUpgrade()) {
                    ao.migrate((Class[])AOEntities.getEntityTypesAsArray());
                }
                this.performUpgrade(activeObjectsUtilities, persistenceIndex);
                LOGGER.info("[Upgrade task to data model version " + this.getDataModelVersion() + "]\tSuccessfully executed.", new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.info("[Upgrade task to data model version " + this.getDataModelVersion() + "]\tFailed to migrate.", new Object[0]);
                LOGGER.exception(ex, Log.LogLevel.INFO);
            }
        }
    }
}

