/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.replanning.AOReplanning;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class U_01202_ReplanningStreamsUpgradeTask
extends BaseUpgradeTask {
    @Override
    protected int getDataModelVersion() {
        return 1202;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        UpgradeSQL sql = new UpgradeSQL(this, utils);
        sql.perform();
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return false;
    }

    private static class UpgradeSQL
    extends BaseTransactionalAOPersistenceSQL {
        private final BaseUpgradeTask task;
        private final ActiveObjectsUtilities utils;

        public UpgradeSQL(BaseUpgradeTask task, ActiveObjectsUtilities utils) {
            super(utils);
            this.task = task;
            this.utils = utils;
        }

        private Connection getConnection() throws SQLException {
            return this.task.getOrCreateConnection(this.utils.getAccessor());
        }

        public void perform() throws Exception {
            ArrayList updates = Lists.newArrayList();
            for (final Map.Entry<String, String> entry : this.getMissingReplanningStreamAssignments().entrySet()) {
                updates.add(new IUpdate(){

                    @Override
                    public void sql(AOQueryGenerator generator) throws Exception {
                        generator.withTable(AOReplanning.class, "r").insert().tableNoAlias("r").raw("(").colNoAlias("r", "targetId").colNoAlias("r", "targetType").colNoAlias("r", "workItem").raw(") VALUES (").numeric((String)entry.getValue()).raw(",").str("stream").raw(",").numeric((String)entry.getKey()).raw(")");
                    }
                });
            }
            this.handleUpdatesInTransaction(updates, this.getConnection());
        }

        private Map<String, String> getMissingReplanningStreamAssignments() throws SQLException {
            return this.sql(new IQuery<Map<String, String>>(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOReplanning.class, "r1").withTable(AOReplanning.class, "r2").withTable(AORelease.class, "e").withTable(AOWorkItem.class, "w").withTable(AOStream.class, "s").select().col("r1", "workItem").raw(",").raw("COALESCE(").col("e", "aostream").colId("s").raw(")").from("r1").leftJoin().table("r2").on().col("r1", "workItem").eq().col("r2", "workItem").and().col("r2", "targetType").eq().str("stream").leftJoin().table("e").on().colId("e").eq().colAsInt("r1", "targetId").leftJoin().table("w").on().colId("w").eq().col("r1", "workItem").leftJoin().table("s").on().col("s", "aoPlan").eq().col("w", "aoPlan").where().col("r1", "targetType").eq().str("release").and().colId("r2").isNull();
                }

                @Override
                public Map<String, String> handleResult(ResultSet result) throws Exception {
                    HashMap retVal = Maps.newHashMap();
                    while (result.next()) {
                        retVal.put(BaseAOPersistenceSQL.getString(result, 1), BaseAOPersistenceSQL.getString(result, 2));
                    }
                    return retVal;
                }
            }, this.getConnection());
        }
    }
}

