/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.filter;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimationEnrichedWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.filter.IWorkItemFilter;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import java.util.ArrayList;
import java.util.List;

public class EstimateFilter {
    private double min;
    private double max;

    public EstimateFilter(IWorkItemFilter filter) {
        this.min = filter != null && filter.getMininumEstimate() != null ? filter.getMininumEstimate() : 0.0;
        this.max = filter != null && filter.getMaximumEstimate() != null ? filter.getMaximumEstimate() : Double.MAX_VALUE;
    }

    public boolean allowedByFilter(RestWorkItem item) {
        if (item.getChildren() == null || item.getChildren().size() == 0) {
            double estimates = EstimateFilter.total(item);
            return estimates >= this.min && estimates <= this.max || item.getId().equals("-1");
        }
        return true;
    }

    public static List<IWorkItem> filter(List<IWorkItem> items, Double minEstimates, Double maxEstimates) {
        if (minEstimates == null && maxEstimates == null) {
            return items;
        }
        double min = 0.0;
        if (minEstimates != null) {
            min = minEstimates;
        }
        double max = Double.MAX_VALUE;
        if (maxEstimates != null) {
            max = maxEstimates;
        }
        ArrayList asRest = Lists.newArrayList();
        for (IWorkItem item : items) {
            asRest.add((RestWorkItem)item);
        }
        return Lists.newArrayList(EstimateFilter.filterRecursive(asRest, min, max));
    }

    private static List<RestWorkItem> filterRecursive(List<RestWorkItem> items, Double min, Double max) {
        ArrayList retVal = Lists.newArrayList();
        for (RestWorkItem item : items) {
            if (item.getChildren() == null || item.getChildren().size() == 0) {
                double estimates = EstimateFilter.total(item);
                if (!(estimates >= min && estimates <= max) && !item.getId().equals("-1")) continue;
                retVal.add(item);
                continue;
            }
            List<RestWorkItem> filteredChildren = EstimateFilter.filterRecursive(item.getRestChildren(), min, max);
            if (filteredChildren.size() <= 0 && !item.getId().equals("-1")) continue;
            item.setChildren(filteredChildren);
            retVal.add(item);
        }
        return retVal;
    }

    private static double total(IEstimationEnrichedWorkItem workItem) {
        if (workItem.getCurrentEstimates().getTotal().isPresent()) {
            return ((IEstimate)workItem.getCurrentEstimates().getTotal().get()).getEstimate();
        }
        double retVal = 0.0;
        for (IEstimate estimate : workItem.getCurrentEstimates().getStages()) {
            retVal += estimate.getEstimate().doubleValue();
        }
        for (IEstimate estimate : workItem.getCurrentEstimates().getSkills()) {
            retVal += estimate.getEstimate().doubleValue();
        }
        return retVal;
    }
}

