/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.extensionlinks;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IExtendable;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.extensionlinks.AddExtensionLinkRequest;
import com.radiantminds.roadmap.common.handlers.extensionlinks.InvalidLinkException;
import com.radiantminds.roadmap.common.handlers.extensionlinks.RemoveExtensionLinkRequest;
import com.radiantminds.roadmap.common.handlers.extensionlinks.SecureExtensionLinkHandler;
import com.radiantminds.roadmap.common.handlers.extensionlinks.SetExtensionLinksRequest;
import java.sql.SQLException;
import java.util.Collection;
import javax.ws.rs.core.Response;

public abstract class BaseExtensionLinkHandler<TEntity extends IExtendable, TPersistence extends IEntityPersistence<TEntity>>
implements SecureExtensionLinkHandler<TEntity> {
    private static final Log LOGGER = Log.with(BaseExtensionLinkHandler.class);
    protected final TPersistence persistence;
    protected final PortfolioExtensionLinkPersistence extensionLinkPersistence;

    protected BaseExtensionLinkHandler(TPersistence persistence, PortfolioExtensionLinkPersistence extensionLinkPersistence) {
        this.persistence = persistence;
        this.extensionLinkPersistence = extensionLinkPersistence;
    }

    protected abstract void onBeforeAdd(String var1, AddExtensionLinkRequest var2, Class<TEntity> var3) throws InvalidLinkException, SQLException;

    protected abstract Object generateResponseEntity(EntityContext<TEntity> var1, Collection<AddExtensionLinkRequest> var2) throws Exception;

    @Override
    public Response addExtensionLink(EntityContext<TEntity> entityContext, AddExtensionLinkRequest addRequest) throws Exception {
        Preconditions.checkNotNull(entityContext, (Object)"entityContext must not be null");
        Preconditions.checkNotNull((Object)addRequest, (Object)"request must not be null");
        LOGGER.debug("received request: %s", addRequest);
        this.onBeforeAdd(entityContext.getEntityId(), addRequest, this.persistence.getEntityClass());
        this.extensionLinkPersistence.addExtensionLink(this.persistence.getDbInterfaceClass(), entityContext.getEntityId(), addRequest.getKey(), addRequest.getLink());
        LOGGER.debug("update successful", new Object[0]);
        Object response = this.generateResponseEntity(entityContext, addRequest);
        return entityContext.okForEntityUpdate(response);
    }

    @Override
    public Response setExtensionLinks(EntityContext<TEntity> entityContext, SetExtensionLinksRequest request) throws Exception {
        Preconditions.checkNotNull(entityContext, (Object)"entityContext must not be null");
        Preconditions.checkNotNull((Object)request, (Object)"request must not be null");
        LOGGER.debug("received request: %s", request);
        this.extensionLinkPersistence.removeAllExtensionLinksWhereKeyLike(this.persistence.getDbInterfaceClass(), entityContext.getEntityId(), "", new String[0]);
        for (AddExtensionLinkRequest link : request.getLinks()) {
            this.addExtensionLink(entityContext, link);
        }
        LOGGER.debug("update successful", new Object[0]);
        Object response = this.generateResponseEntity(entityContext, request);
        return entityContext.okForEntityUpdate(response);
    }

    @Override
    public Response removeExtensionLink(EntityContext<TEntity> entityContext, RemoveExtensionLinkRequest request) throws Exception {
        Preconditions.checkNotNull(entityContext, (Object)"entityContext must not be null");
        Preconditions.checkNotNull((Object)request, (Object)"request must not be null");
        LOGGER.debug("received request: %s", request);
        this.extensionLinkPersistence.removeExtensionLink(this.persistence.getDbInterfaceClass(), entityContext.getEntityId(), request.getKey(), request.getLink());
        LOGGER.debug("update successful", new Object[0]);
        return entityContext.okForEntityUpdate();
    }

    private Object generateResponseEntity(EntityContext<TEntity> entityContext, AddExtensionLinkRequest addRequest) throws Exception {
        return this.generateResponseEntity(entityContext, Sets.newHashSet((Object[])new AddExtensionLinkRequest[]{addRequest}));
    }

    private Object generateResponseEntity(EntityContext<TEntity> entityContext, SetExtensionLinksRequest setRequest) throws Exception {
        return this.generateResponseEntity(entityContext, setRequest.getLinks());
    }
}

