/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.permissions;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissionAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class PlanPermissionCheckResult {
    private final Map<PlanPermission, PlanPermissionAuthentication> permissions;

    PlanPermissionCheckResult(Map<PlanPermission, PlanPermissionAuthentication> permissions) {
        this.permissions = permissions;
    }

    public PlanPermissionAuthentication getAuthentication(PlanPermission permission) {
        return this.permissions.get((Object)permission);
    }

    public boolean isDenied() {
        for (PlanPermissionAuthentication auth : this.permissions.values()) {
            if (auth == PlanPermissionAuthentication.Denied) continue;
            return false;
        }
        return true;
    }

    public boolean needsPluginPermission() {
        for (PlanPermissionAuthentication auth : this.permissions.values()) {
            if (auth != PlanPermissionAuthentication.Authorized) continue;
            return false;
        }
        return true;
    }

    public Collection<PlanPermission> getValidPermissions() {
        ArrayList retVal = Lists.newArrayList();
        for (Map.Entry<PlanPermission, PlanPermissionAuthentication> entry : this.permissions.entrySet()) {
            if (entry.getValue() == PlanPermissionAuthentication.Denied) continue;
            retVal.add(entry.getKey());
        }
        return retVal;
    }
}

