/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.admin;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.generator.IPlanPersistency;
import com.radiantminds.roadmap.common.data.generator.PlanPersistencyFactory;
import com.radiantminds.roadmap.common.data.generator.rand.IRandomizedPlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.RandomizedPlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.RandomizedBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.RandomizedStoryConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.RandomizedStructuredEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.RandomizedUnstructuredEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.settings.IRandomizedSettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.settings.RandomizedSettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.teams.RandomizedResourceConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.teams.RandomizedTeamConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.teams.RandomizedTeamsConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.time.RandomizedTimePlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.template.PlanTemplate;
import com.radiantminds.roadmap.common.extensions.mode.DevModeExtension;
import com.radiantminds.roadmap.common.rest.admin.rest.RestPlanGeneratorConfiguration;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/mock")
@Component
public class PlanMockService {
    private static final Log LOGGER = Log.with(PlanMockService.class);
    private final PlanPersistencyFactory planPersistencyFactory;
    private final DevModeExtension devModeExtension;

    @Autowired
    public PlanMockService(PlanPersistencyFactory planPersistencyFactory, DevModeExtension devModeExtension) {
        this.planPersistencyFactory = planPersistencyFactory;
        this.devModeExtension = devModeExtension;
    }

    @POST
    @Path(value="/generate")
    public Response createRandomPlan(RestPlanGeneratorConfiguration configuration) throws Exception {
        if (!this.devModeExtension.isDevModeAllowed()) {
            throw new Exception("Dev action performed in non-dev environment.");
        }
        Long now = System.currentTimeMillis();
        RandomizedStoryConfiguration storyConfiguration = new RandomizedStoryConfiguration.Builder().withOverallEstimationBetweeen(configuration.backlog.minOverallEstimation, configuration.backlog.maxOverallEstimation).build();
        RandomizedStructuredEpicConfiguration structuredConfig = new RandomizedStructuredEpicConfiguration.Builder().withStoryCountBetween(configuration.backlog.minStories, configuration.backlog.maxStories).withStoryConfiguration(storyConfiguration).build();
        RandomizedUnstructuredEpicConfiguration unstructuredConfig = new RandomizedUnstructuredEpicConfiguration.Builder().withOverallEstimationBetween(configuration.backlog.minOverallEstimation, configuration.backlog.maxOverallEstimation).build();
        RandomizedBacklogConfiguration backlog = new RandomizedBacklogConfiguration.Builder().withEpicCount(configuration.backlog.epics).withStructuredEpicPercentage(configuration.backlog.structuredPercentage).withStructuredEpicConfiguration(structuredConfig).withUnstructuredEpicConfiguration(unstructuredConfig).build();
        RandomizedResourceConfiguration resource = new RandomizedResourceConfiguration.Builder().withNumberOfSkillsBetween(configuration.teams.minSkills, configuration.teams.maxSkills).build();
        RandomizedTeamConfiguration team = new RandomizedTeamConfiguration.Builder().withResourceCountBetween(configuration.teams.minResources, configuration.teams.maxResources).withResourceConfiguration(resource).build();
        RandomizedTeamsConfiguration teams = new RandomizedTeamsConfiguration.Builder().withTeamsCount(configuration.teams.teams).withResourceConfiguration(team).build();
        RandomizedTimePlanConfiguration timePlan = new RandomizedTimePlanConfiguration.Builder().withReleaseCount(configuration.timePlan.releases).withReleaseDurationInDaysBetween(configuration.timePlan.minDuration, configuration.timePlan.maxDuration).withStartDate(new DateTime((Object)configuration.timePlan.getStartDate())).build();
        IRandomizedSettingsConfiguration settings = new RandomizedSettingsConfiguration.Builder().stages(configuration.settings.stages).withNumberOfSkillBetween(configuration.settings.minSkills, configuration.settings.maxSkills).build();
        IRandomizedPlanConfiguration randomizedPlanConfiguration = new RandomizedPlanConfiguration.Builder().withSettingsConfiguration(settings).withTeamsConfiguration(teams).withTimePlanConfiguration(timePlan).withBacklogConfiguration(backlog).build();
        IPlanPersistency planPersistency = this.planPersistencyFactory.create();
        IPlan plan = planPersistency.persistPlan(randomizedPlanConfiguration.toPlanConfiguration(), PlanTemplate.BLANK);
        LOGGER.info("Plan creation took " + (System.currentTimeMillis() - now) + "ms", new Object[0]);
        return Response.ok((Object)plan.getId()).build();
    }
}

