/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.common;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.SortOrderUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.MoveMode;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.rest.common.EntityNotFoundException;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.entities.common.IRankable;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestBulkItemResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestItemResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.common.RestVersionedId;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public class SubCollectionUtils {
    private final SortOrderUtils sortOrderUtils;
    private final PortfolioWorkItemPersistence workItemPersistence;

    public SubCollectionUtils(ActiveObjectsUtilities activeObjectsUtilities, PortfolioWorkItemPersistence workItemPersistence) {
        this.workItemPersistence = workItemPersistence;
        this.sortOrderUtils = new SortOrderUtils(activeObjectsUtilities);
    }

    public void tryRanking(@Nullable String newParentDbId, String workItemId, @Nullable RestRank rank) throws SQLException, PersistenceException {
        if (newParentDbId != null && !this.workItemPersistence.isInitiative(newParentDbId) && rank != null) {
            String anchor = rank.getAnchor() != null ? rank.getAnchor() : newParentDbId;
            this.performEntityRanking(AOWorkItem.class, workItemId, anchor, null, rank.getMoveMode());
        }
    }

    private void performEntityRanking(Class<?> aoClazz, String id, String anchor, String orderRangeIdentifier, MoveMode mode) throws SQLException, PersistenceException {
        boolean handleAsWorkItem;
        boolean bl = handleAsWorkItem = AOWorkItem.class.isAssignableFrom(aoClazz) && !this.workItemPersistence.isInitiative(id);
        if (handleAsWorkItem) {
            this.workItemPersistence.move(id, anchor, mode);
        } else {
            this.sortOrderUtils.move(orderRangeIdentifier, aoClazz, id, mode, anchor);
        }
    }

    public <TEntityType extends IIdentifiable, TAOEntityType extends TEntityType> Response rankEntity(EntityContext entityContext, Class<TAOEntityType> aoClazz, IEntityPersistence<TEntityType> persistence, String parentType, RestRank rank) throws Exception {
        List<RestVersionedId> ids = rank.getElementIds();
        MoveMode mode = rank.getMoveMode();
        String anchor = rank.getAnchor();
        if (ids == null || ids.size() == 0) {
            return ResponseBuilder.badRequest(RestMessaging.error("missing-id", "No identifiers supplied for ranking."));
        }
        if (anchor != null && !persistence.exists(anchor)) {
            return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
        }
        String orderRangeIdentifier = parentType + "-" + entityContext.getEntityId();
        RestBulkItemResult retVal = new RestBulkItemResult();
        for (RestVersionedId versionedId : Lists.reverse(ids)) {
            String id = versionedId.getId();
            try {
                if (id == null) {
                    throw new EntityNotFoundException();
                }
                if (!ISortable.class.isAssignableFrom(aoClazz)) continue;
                ModificationResult modificationResult = new ModificationResult(null, id);
                this.performEntityRanking(aoClazz, id, anchor, orderRangeIdentifier, mode);
                RestItemResult result = new RestItemResult(id, modificationResult);
                retVal.addResult(result);
            }
            catch (EntityNotFoundException ex) {
                retVal.addResult(new RestItemResult(id, RestMessaging.entityNotFound().getMessage()));
            }
            catch (Exception ex) {
                retVal.addResult(new RestItemResult(id, ex.getMessage()));
            }
        }
        return entityContext.ok(retVal);
    }

    public <TCollectionType extends IIdentifiable, TEntityType extends IIdentifiable, TRestEntityType extends TEntityType, TAOEntityType extends TEntityType> Response handleAddEntityToCollection(EntityContext<TCollectionType> entityContext, Class<TAOEntityType> aoClazz, String parentType, TRestEntityType newEntity, SubCollectionUtilsCallback<TCollectionType, TEntityType, TRestEntityType> callback) throws Exception {
        Response preOpsCheckResponse = callback.preOperationChecks();
        if (preOpsCheckResponse != null) {
            return preOpsCheckResponse;
        }
        if (newEntity.getId() != null) {
            return ResponseBuilder.badRequest(RestMessaging.addWithId());
        }
        callback.setParent(entityContext.getEntity(), newEntity);
        TEntityType stored = callback.persist(newEntity);
        callback.afterPostPersisting(newEntity, stored);
        if (newEntity instanceof IRankable) {
            IRankable rankableEntity = (IRankable)newEntity;
            MoveMode mode = null;
            String anchor = null;
            if (rankableEntity.getInsertAfter() != null) {
                mode = MoveMode.AFTER;
                anchor = rankableEntity.getInsertAfter();
            } else if (rankableEntity.getInsertBefore() != null) {
                mode = MoveMode.BEFORE;
                anchor = rankableEntity.getInsertBefore();
            }
            if (mode != null) {
                if (AOWorkItem.class.isAssignableFrom(aoClazz) && !WorkItems.Types.INITIATIVE.equals(((RestWorkItem)newEntity).getType())) {
                    this.workItemPersistence.move(stored.getId(), anchor, mode);
                } else {
                    this.sortOrderUtils.move(parentType + "-" + entityContext.getEntityId(), aoClazz, stored.getId(), mode, anchor);
                }
            }
        }
        if (stored instanceof ISortable && ((ISortable)stored).getSortOrder() == null) {
            throw new PersistenceException("[DEV-680] Newly added sortable entity of type '" + aoClazz.getSimpleName() + "' has no sort order.");
        }
        ModificationResult modificationResult = callback.buildModificationResult(stored);
        return entityContext.ok(modificationResult);
    }
}

