/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.plans;

import com.google.common.base.MoreObjects;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.LinkingMode;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.data.entities.plans.WeekdayConfiguration;
import com.radiantminds.roadmap.common.data.generator.template.PlanTemplate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlanConfiguration;
import com.radiantminds.roadmap.common.rest.entities.plans.RestNonWorkingDay;
import com.radiantminds.roadmap.common.rest.entities.plans.RestWeekdayConfiguration;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatch;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="config")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestPlanConfiguration
implements IPlanConfiguration {
    @XmlElement
    @SchedulingRelevantPatch
    private Boolean enableSprintExceededWarnings;
    @XmlElement
    @SchedulingRelevantPatch
    private Boolean hasSprintConstraint;
    @XmlElement
    @SchedulingRelevantPatch
    private Boolean strictStageDivision;
    @XmlElement
    @SchedulingRelevantPatch
    private Boolean isSyncDependeeStartEnabled;
    @XmlElement
    @SchedulingRelevantPatch
    private Long minimumLoadForUnstructuredEpics;
    @XmlElement
    @SchedulingRelevantPatch
    private Long maxAssignableResourcesPerStory;
    @XmlElement
    @SchedulingRelevantPatch
    private String planningUnit;
    @XmlElement
    @SchedulingRelevantPatch
    private Integer globalSprintLength;
    @XmlElement
    @SchedulingRelevantPatch
    private Double globalDefaultVelocity;
    @XmlElement
    @SchedulingRelevantPatch
    private Double defaultStoryEstimate;
    @XmlElement
    @SchedulingRelevantPatch
    private Double defaultEpicEstimate;
    @XmlElement
    @SchedulingRelevantPatch
    private Integer heuristicThreshold;
    @XmlElement
    @SchedulingRelevantPatch
    private Double hoursPerDay;
    @XmlElement
    @SchedulingRelevantPatch
    private Integer workDaysInWeek;
    @XmlElement
    private String linkingMode;
    @XmlElement
    private Integer backlogRecordLimit;
    @XmlElement
    private Integer importLimit;
    @XmlElement
    private String progressTrackerType;
    @XmlElement
    private Boolean progressCompletedIfResolved;
    @XmlElement
    private Boolean progressDisplayUnestimated;
    @XmlElement
    private String progressManualFieldName;
    @XmlElement
    private String progressStorySubtaskMode;
    @XmlElement
    List<RestNonWorkingDay> nonWorkingDays;
    @XmlElement
    private Boolean syncStories;
    @XmlElement
    private Boolean syncEpics;
    @XmlElement
    private Boolean syncInitiatives;
    @XmlElement
    private Boolean syncSummary;
    @XmlElement
    private Boolean syncDescription;
    @XmlElement
    private Boolean syncEstimates;
    @XmlElement
    private Boolean suggestReplanningEstimates;
    private PlanTemplate templateType;
    private WeekdayConfiguration weekdayConfiguration;

    protected RestPlanConfiguration() {
    }

    public RestPlanConfiguration(Boolean enableSprintExceededWarnings, Boolean hasSprintConstraint, Boolean isSyncDependeeStartEnabled, Boolean strictStoryStageDivision, Long minimumLoadForUnstructuredEpics, Long maxAssignableResourcesPerStory, String planningUnit, Integer heuristicThreshold, Integer globalSprintLength, Double globalDefaultVelocity, String linkingMode, PlanTemplate templateType, Integer backlogRecordLimit, Integer importLimit, String progressTrackerType, Boolean progressCompletedIfResolved, Boolean progressDisplayUnestimated, String progressManualFieldName, String progressStorySubtaskMode, Double defaultStoryEstimate, Double defaultEpicEstimate, Double hoursPerDay, Integer workDaysPerWeek, Boolean suggestReplanningEstimates, Boolean syncStories, Boolean syncEpics, Boolean syncInitiatives, Boolean syncSummary, Boolean syncDescription, Boolean syncEstimates) {
        this.enableSprintExceededWarnings = (Boolean)MoreObjects.firstNonNull((Object)enableSprintExceededWarnings, (Object)false);
        this.hasSprintConstraint = (Boolean)MoreObjects.firstNonNull((Object)hasSprintConstraint, (Object)true);
        this.isSyncDependeeStartEnabled = (Boolean)MoreObjects.firstNonNull((Object)isSyncDependeeStartEnabled, (Object)false);
        this.strictStageDivision = (Boolean)MoreObjects.firstNonNull((Object)strictStoryStageDivision, (Object)true);
        this.minimumLoadForUnstructuredEpics = (Long)MoreObjects.firstNonNull((Object)minimumLoadForUnstructuredEpics, (Object)5L);
        this.maxAssignableResourcesPerStory = (Long)MoreObjects.firstNonNull((Object)maxAssignableResourcesPerStory, (Object)5L);
        this.planningUnit = (String)MoreObjects.firstNonNull((Object)planningUnit, (Object)PlanningUnit.DAYS.toString());
        this.globalSprintLength = (Integer)MoreObjects.firstNonNull((Object)globalSprintLength, (Object)2);
        this.globalDefaultVelocity = (Double)MoreObjects.firstNonNull((Object)globalDefaultVelocity, (Object)50.0);
        this.heuristicThreshold = (Integer)MoreObjects.firstNonNull((Object)heuristicThreshold, (Object)1000);
        this.linkingMode = (String)MoreObjects.firstNonNull((Object)linkingMode, (Object)LinkingMode.MultipleProjects.toString());
        this.templateType = (PlanTemplate)((Object)MoreObjects.firstNonNull((Object)((Object)templateType), (Object)((Object)PlanTemplate.BLANK)));
        this.backlogRecordLimit = (Integer)MoreObjects.firstNonNull((Object)backlogRecordLimit, (Object)500);
        this.importLimit = (Integer)MoreObjects.firstNonNull((Object)importLimit, (Object)100);
        this.progressTrackerType = (String)MoreObjects.firstNonNull((Object)progressTrackerType, (Object)TrackerType.TimeBased.toString());
        this.progressCompletedIfResolved = (Boolean)MoreObjects.firstNonNull((Object)progressCompletedIfResolved, (Object)true);
        this.progressDisplayUnestimated = (Boolean)MoreObjects.firstNonNull((Object)progressDisplayUnestimated, (Object)false);
        this.progressManualFieldName = progressManualFieldName;
        this.progressStorySubtaskMode = (String)MoreObjects.firstNonNull((Object)progressStorySubtaskMode, (Object)"resolved");
        this.defaultStoryEstimate = defaultStoryEstimate;
        this.defaultEpicEstimate = defaultEpicEstimate;
        this.hoursPerDay = (Double)MoreObjects.firstNonNull((Object)hoursPerDay, (Object)8.0);
        this.workDaysInWeek = (Integer)MoreObjects.firstNonNull((Object)workDaysPerWeek, (Object)WeekdayConfiguration.MON_TO_FRI.toInteger());
        this.weekdayConfiguration = RestWeekdayConfiguration.fromInteger(this.workDaysInWeek);
        this.syncStories = (Boolean)MoreObjects.firstNonNull((Object)syncStories, (Object)false);
        this.syncEpics = (Boolean)MoreObjects.firstNonNull((Object)syncEpics, (Object)false);
        this.syncInitiatives = (Boolean)MoreObjects.firstNonNull((Object)syncInitiatives, (Object)false);
        this.syncSummary = (Boolean)MoreObjects.firstNonNull((Object)syncSummary, (Object)true);
        this.syncDescription = (Boolean)MoreObjects.firstNonNull((Object)syncDescription, (Object)true);
        this.syncEstimates = (Boolean)MoreObjects.firstNonNull((Object)syncEstimates, (Object)false);
        this.suggestReplanningEstimates = (Boolean)MoreObjects.firstNonNull((Object)suggestReplanningEstimates, (Object)true);
    }

    public RestPlanConfiguration(AOPlanConfiguration planConfiguration) {
        this(planConfiguration.getSprintExceededWarn(), planConfiguration.getHasSprintConstraint(), planConfiguration.getSyncStartEnabled(), planConfiguration.getStrictStageDivision(), planConfiguration.getMinLoadUnstrEpics(), planConfiguration.getMaxResourcesPerStory(), planConfiguration.getPlanningUnit(), planConfiguration.getHeuristicThreshold(), planConfiguration.getGlobalSprintLength(), planConfiguration.getGlobalDefaultVelocity(), planConfiguration.getLinkingMode(), RestPlanConfiguration.tryParsePlanTemplate(planConfiguration), planConfiguration.getBacklogRecordLimit(), planConfiguration.getImportLimit(), planConfiguration.getProgressTrackerType() != null ? planConfiguration.getProgressTrackerType().toString() : null, planConfiguration.getProgCmpltIfRslvd(), planConfiguration.getProgDsplUnestRtio(), planConfiguration.getProgFieldName(), planConfiguration.getProgStrySubTaskMode(), planConfiguration.getDefaultStoryEstimate(), planConfiguration.getDefaultEpicEstimate(), planConfiguration.getHoursPerDay(), planConfiguration.getAOWeekdayConfig(), planConfiguration.getSuggestReplEstimates(), planConfiguration.getSyncStories(), planConfiguration.getSyncEpics(), planConfiguration.getSyncInitiatives(), planConfiguration.getSyncSummary(), planConfiguration.getSyncDescription(), planConfiguration.getSyncEstimates());
    }

    private static PlanTemplate tryParsePlanTemplate(AOPlanConfiguration planConfiguration) {
        PlanTemplate template = null;
        if (planConfiguration.getTemplateType() != null) {
            template = PlanTemplate.parse(planConfiguration.getTemplateType());
        }
        return template;
    }

    public static RestPlanConfiguration getDefaultConfiguration() {
        return new RestPlanConfiguration(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Override
    public String getTemplateType() {
        if (this.templateType != null) {
            return this.templateType.toString();
        }
        return null;
    }

    @Override
    public Boolean getSprintExceededWarn() {
        return this.enableSprintExceededWarnings;
    }

    @Override
    public Boolean getHasSprintConstraint() {
        return this.hasSprintConstraint;
    }

    @Override
    public Long getMinLoadUnstrEpics() {
        return this.minimumLoadForUnstructuredEpics;
    }

    @Override
    public Long getMaxResourcesPerStory() {
        return this.maxAssignableResourcesPerStory;
    }

    @Override
    public String getPlanningUnit() {
        return this.planningUnit;
    }

    @Override
    public Integer getHeuristicThreshold() {
        return this.heuristicThreshold;
    }

    @Override
    public Integer getGlobalSprintLength() {
        return this.globalSprintLength;
    }

    @Override
    public Double getGlobalDefaultVelocity() {
        return this.globalDefaultVelocity;
    }

    @Override
    public Double getHoursPerDay() {
        return this.hoursPerDay;
    }

    @Override
    public WeekdayConfiguration getWeekdayConfiguration() {
        if (this.weekdayConfiguration == null && this.workDaysInWeek != null) {
            this.weekdayConfiguration = RestWeekdayConfiguration.fromInteger(this.workDaysInWeek);
        }
        return this.weekdayConfiguration;
    }

    @Override
    public String getLinkingMode() {
        return this.linkingMode;
    }

    @Override
    public Integer getBacklogRecordLimit() {
        return this.backlogRecordLimit;
    }

    @Override
    public Integer getImportLimit() {
        return this.importLimit;
    }

    @Override
    public TrackerType getProgressTrackerType() {
        if (this.progressTrackerType == null) {
            return null;
        }
        return TrackerType.fromString(this.progressTrackerType);
    }

    @Override
    public Boolean getProgCmpltIfRslvd() {
        return this.progressCompletedIfResolved;
    }

    @Override
    public Boolean getProgDsplUnestRtio() {
        return this.progressDisplayUnestimated;
    }

    @Override
    public String getProgFieldName() {
        return this.progressManualFieldName;
    }

    @Override
    public String getProgStrySubTaskMode() {
        return this.progressStorySubtaskMode;
    }

    @Override
    public Boolean getSyncStartEnabled() {
        return this.isSyncDependeeStartEnabled;
    }

    @Override
    public Boolean getStrictStageDivision() {
        return this.strictStageDivision;
    }

    @Override
    public Boolean getSyncStories() {
        return this.syncStories;
    }

    @Override
    public Boolean getSyncEpics() {
        return this.syncEpics;
    }

    @Override
    public Boolean getSyncInitiatives() {
        return this.syncInitiatives;
    }

    @Override
    public Boolean getSyncSummary() {
        return this.syncSummary;
    }

    @Override
    public Boolean getSyncDescription() {
        return this.syncDescription;
    }

    @Override
    public Boolean getSyncEstimates() {
        return this.syncEstimates;
    }

    @Override
    public Double getDefaultStoryEstimate() {
        return this.defaultStoryEstimate;
    }

    @Override
    public Double getDefaultEpicEstimate() {
        return this.defaultEpicEstimate;
    }

    @Override
    public Boolean getSuggestReplEstimates() {
        return this.suggestReplanningEstimates;
    }

    public void setNonWorkingDays(List<RestNonWorkingDay> nonWorkingDays) {
        this.nonWorkingDays = nonWorkingDays;
    }

    public List<RestNonWorkingDay> getNonWorkingDays() {
        return this.nonWorkingDays;
    }

    public void setFullSyncEnabled() {
        this.syncEpics = true;
        this.syncInitiatives = true;
        this.syncStories = true;
        this.syncEstimates = true;
        this.syncSummary = true;
        this.syncDescription = true;
    }

    protected void setWorkDaysInWeek(Integer wdiw) {
        this.workDaysInWeek = wdiw;
    }
}

