/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.plans;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanImporter;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics.DynamicValueHandlers;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.DocumentLegacyChecker;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.handlers.ClientIdCache;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.rest.entities.plans.RestCreatePlanRequest;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlan;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.plans.PlanServiceHandler;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/plans")
@Component
public class PlanService
extends BaseOperationsService<IPlan, RestPlan> {
    private final PlanServiceHandler handler;
    private final ClientIdCache clientIdCache;

    @Autowired
    public PlanService(XmlExportablePersistenceIndex index, SecuredInvocationHandlerFactory handlerFactory, SchedulingPlanFactory schedulingPlanFactory, DocumentLegacyChecker documentLegacyChecker, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioPermissionPersistence permissionPersistence, PlanPermissions planPermissionHandler, PluginPermissions pluginPermissionHandler, UserExtension userExtension, AnalyticsExtension analyticsExtension, Scheduling scheduling, DynamicValueHandlers dynamicValueHandlers, ClientIdCache clientIdCache) {
        super(RestPlan.class, planPersistence, handlerFactory);
        this.clientIdCache = clientIdCache;
        this.handler = handlerFactory.createProxy(PlanServiceHandler.class, new PlanServiceHandler.Impl(userExtension, analyticsExtension, planPermissionHandler, pluginPermissionHandler, planPersistence, scheduling, new PlanImporter(index, activeObjectsUtilities, schedulingPlanFactory, documentLegacyChecker, permissionPersistence, dynamicValueHandlers)), planPersistence);
    }

    @Override
    protected RestPlan transform(IPlan entity, boolean includeReplanningData) {
        return new RestPlan(entity);
    }

    @Override
    protected Response update(RestPlan source, IPlan target, boolean allowNull) {
        return this.updateCommons(source, target, allowNull);
    }

    @POST
    public Response postPlan(@QueryParam(value="triggerScheduling") Boolean triggerScheduling, RestCreatePlanRequest planRequest) throws Exception {
        return this.handler.postPlan(planRequest, (Boolean)Optional.fromNullable((Object)triggerScheduling).or((Object)true));
    }

    @Override
    @GET
    @Path(value="/{id}")
    public Response entryGet(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="replanning") Boolean replanning) throws Exception {
        return this.handler.entryGet(EntityContext.from(id, expectedPlanVersion), (Boolean)Optional.fromNullable((Object)replanning).or((Object)false));
    }

    @Override
    @DELETE
    @Path(value="{id}")
    public Response entryDelete(@PathParam(value="id") String id, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.entryDelete(EntityContext.from(id, version, expectedPlanVersion, clientId));
    }

    @GET
    public Response collectionGet(@QueryParam(value="replanning") Boolean replanning) throws Exception {
        return this.handler.collectionGet((Boolean)Optional.fromNullable((Object)replanning).or((Object)false));
    }
}

