/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.common;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.scheduling.common.TimeAmountTransformer;

class WorkDayTimeAmountTransformer
implements TimeAmountTransformer {
    private double hoursPerDay;

    WorkDayTimeAmountTransformer(double hoursPerDay) {
        Preconditions.checkArgument((hoursPerDay >= 0.0 ? 1 : 0) != 0);
        this.hoursPerDay = hoursPerDay;
    }

    @Override
    public float getWorkInPlanningUnit(double hours) {
        return RmUtils.toFloat(hours / this.hoursPerDay);
    }

    @Override
    public PlanningUnit getPlanningUnit() {
        return PlanningUnit.DAYS;
    }

    @Override
    public float getNormalizedWorkDemand(float value) {
        return RmUtils.toFloat((double)value * this.hoursPerDay);
    }
}

