/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities.transferables;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingAbility;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableAbility;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableInterval;
import java.util.List;

public class TransferablePerson
implements SchedulingPerson {
    private List<TransferableAbility> abilities;
    private List<TransferableInterval> presences;
    private List<TransferableInterval> absences;
    private String id;

    TransferablePerson(SchedulingPerson person) {
        this.id = person.getId();
        this.abilities = Lists.newArrayList();
        for (SchedulingAbility schedulingAbility : person.getPersonAbilities()) {
            this.abilities.add(new TransferableAbility(schedulingAbility));
        }
        this.presences = Lists.newArrayList();
        for (SchedulingInterval schedulingInterval : person.getPresenceIntervals()) {
            this.presences.add(new TransferableInterval(schedulingInterval));
        }
        this.absences = Lists.newArrayList();
        for (SchedulingInterval schedulingInterval : person.getAbsenceIntervals()) {
            this.absences.add(new TransferableInterval(schedulingInterval));
        }
    }

    @Override
    public List<? extends SchedulingAbility> getPersonAbilities() {
        return Lists.newArrayList(this.abilities);
    }

    @Override
    public List<? extends SchedulingInterval> getPresenceIntervals() {
        return Lists.newArrayList(this.presences);
    }

    @Override
    public List<? extends SchedulingInterval> getAbsenceIntervals() {
        return Lists.newArrayList(this.absences);
    }

    @Override
    public Optional<? extends SchedulingAbility> getAbilityForSkill(String skillId) {
        for (TransferableAbility ability : this.abilities) {
            if (!ability.getTargetType().equals("skill") || !skillId.equals(String.valueOf(ability.getTargetId()))) continue;
            return Optional.of((Object)ability);
        }
        return Optional.absent();
    }

    @Override
    public Optional<? extends SchedulingAbility> getAbilityForStage(String stageId) {
        for (TransferableAbility ability : this.abilities) {
            if (!ability.getTargetType().equals("stage") || !stageId.equals(String.valueOf(ability.getTargetId()))) continue;
            return Optional.of((Object)ability);
        }
        return Optional.absent();
    }

    @Override
    public String getId() {
        return this.id;
    }
}

