/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IReleaseStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IResourceTypeDescription;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IScheduleStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISprintData;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.PlanStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ReleaseStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ResourceTypeDescription;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.SprintData;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IEpisodeStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IRoadmapStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IWorkSlotData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class RoadmapStatisticsTransformer {
    private ITimeTransformer timeTransformer;

    RoadmapStatisticsTransformer(ITimeTransformer timeTransformer) {
        this.timeTransformer = timeTransformer;
    }

    IScheduleStatistics transform(IRoadmapStatistics roadMapStatistics) {
        Set<IWorkSlotData> workSlotStats = roadMapStatistics.getWorkSlotStatistics();
        Set<ISprintData> sprintStats = this.convertSprintStatistics(workSlotStats);
        Set<IEpisodeStatistics> episodeStatistics = roadMapStatistics.getEpisodeStatistics();
        Set<IReleaseStatistics> releaseStats = this.convertReleaseStatistics(episodeStatistics);
        PlanStatistics scheduleStatistics = new PlanStatistics(sprintStats, releaseStats);
        return scheduleStatistics;
    }

    private Set<IReleaseStatistics> convertReleaseStatistics(Set<IEpisodeStatistics> episodeStatistics) {
        HashSet releaseStatistics = Sets.newHashSet();
        for (IEpisodeStatistics episodeStatistic : episodeStatistics) {
            IReleaseStatistics releaseStats = this.convertEpisodeStatistics(episodeStatistic);
            releaseStatistics.add(releaseStats);
        }
        return releaseStatistics;
    }

    private IReleaseStatistics convertEpisodeStatistics(IEpisodeStatistics episodeStatistic) {
        String releaseId = episodeStatistic.getId();
        PlanningUnit planningUnit = this.timeTransformer.getPlanningUnit();
        double avgResourceUtilization = episodeStatistic.getAvgResourceUtilization();
        float workLoad = this.timeTransformer.getWorkInPlanningUnit(episodeStatistic.getWorkLoad());
        float availableWork = this.timeTransformer.getWorkInPlanningUnit(episodeStatistic.getAvailableWork());
        PositivePrimitivesMap<IResourceTypeDescription> freeTypes = RoadmapStatisticsTransformer.convertFromResourceType(episodeStatistic.getFreeTypes());
        Double overbookedWork = null;
        Optional<Double> optionalOverbooked = episodeStatistic.getOverBookedWork();
        if (optionalOverbooked.isPresent()) {
            overbookedWork = this.timeTransformer.getWorkInPlanningUnit((Double)optionalOverbooked.get());
        }
        ReleaseStatistics releaseStatistics = new ReleaseStatistics(releaseId, planningUnit, avgResourceUtilization, workLoad, availableWork, freeTypes, overbookedWork);
        return releaseStatistics;
    }

    private Set<ISprintData> convertSprintStatistics(Set<IWorkSlotData> workSlotStatistics) {
        HashSet sprintStatistics = Sets.newHashSet();
        for (IWorkSlotData slotStats : workSlotStatistics) {
            ISprintData sprintStats = this.convert(slotStats);
            sprintStatistics.add(sprintStats);
        }
        return sprintStatistics;
    }

    private ISprintData convert(IWorkSlotData slotStats) {
        PlanningUnit planningUnit = this.timeTransformer.getPlanningUnit();
        double workLoad = this.timeTransformer.getWorkInPlanningUnit(slotStats.getWorkLoad());
        double availableWork = this.timeTransformer.getWorkInPlanningUnit(slotStats.getAvailableWork());
        PositivePrimitivesMap<IResourceTypeDescription> freeTypes = RoadmapStatisticsTransformer.convertFromResourceType(slotStats.getFreeTypes());
        List<IResourceTypeDescription> bottlenecks = this.convertFromResourceTypes(slotStats.getPriorizedBottleneckResourceTypes());
        long startTimeStamp = this.timeTransformer.getInstant(slotStats.getStart());
        long endTimeStamp = this.timeTransformer.getInstant(slotStats.getEnd());
        ISprintData stats = SprintData.create(slotStats, planningUnit, workLoad, availableWork, freeTypes, bottlenecks, startTimeStamp, endTimeStamp);
        return stats;
    }

    private List<IResourceTypeDescription> convertFromResourceTypes(List<IResourceType> types) {
        ArrayList descriptions = Lists.newArrayList();
        for (IResourceType type : types) {
            descriptions.add(new ResourceTypeDescription(type));
        }
        return descriptions;
    }

    private static PositivePrimitivesMap<IResourceTypeDescription> convertFromResourceType(PositivePrimitivesMap<IResourceType> freeTypes) {
        MutablePositivePrimitivesMap<IResourceTypeDescription> descriptionMap = RmCollectionUtils.newMutablePositiveMap(freeTypes.size());
        for (IResourceType key : freeTypes.keySet()) {
            descriptionMap.put(new ResourceTypeDescription(key), freeTypes.get(key));
        }
        return descriptionMap;
    }
}

