/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IRoadmapStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupCapacityCalculator;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.RoadmapCapacityStatistic;
import java.util.HashSet;
import java.util.Set;

public class CapacityStatisticCalculator {
    private final GroupCapacityCalculator groupCapacityCalculator;

    public CapacityStatisticCalculator(ITimeTransformer timeTransformer) {
        this(new GroupCapacityCalculator(timeTransformer));
    }

    CapacityStatisticCalculator(GroupCapacityCalculator teamCapacityCalculator) {
        this.groupCapacityCalculator = teamCapacityCalculator;
    }

    public RoadmapCapacityStatistic calculateCapacityStatistic(IRoadmapProblem problem, IRoadmapSchedule solution, IRoadmapStatistics roadmapStatistics) {
        final HashSet groupStatistics = Sets.newHashSet();
        for (IResourceGroup group : problem.getResourceGroups()) {
            groupStatistics.add(this.groupCapacityCalculator.calculateStatistic(group, problem, solution, roadmapStatistics));
        }
        return new RoadmapCapacityStatistic(){

            @Override
            public Set<GroupCapacityStatistic> getTeamCapacityStatistics() {
                return groupStatistics;
            }
        };
    }
}

