/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.AnnotatedResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.DependencyViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.Backlog;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IBacklog;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.NoEstimatedWorkItemsDefinedException;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.CylceViolationDetector;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.DefaultEstimatesApplier;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.DependencyDefinitionTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.PriorizedWorkItemsProvider;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.TransformationUtils;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.TransitiveEarliestStartTimeCalculator;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.WorkItemTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.WorkItemTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformationResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BacklogTransformer {
    private static final Log LOGGER = Log.with(BacklogTransformer.class);
    private final PriorizedWorkItemsProvider workItemsFilter;
    private final WorkItemTransformer workItemTransformer;
    private final DefaultEstimatesApplier defaultEstimatesApplier;
    private final DependencyDefinitionTransformer dependencyTransformer;
    private final TransitiveEarliestStartTimeCalculator releaseTimeCalculator = new TransitiveEarliestStartTimeCalculator();
    private final CylceViolationDetector cylceViolationDetector = new CylceViolationDetector();

    public BacklogTransformer(PriorizedWorkItemsProvider workItemsFilter, WorkItemTransformer workItemTransformer, DependencyDefinitionTransformer dependencyTransformer, DefaultEstimatesApplier defaultEstimatesApplier) {
        this.workItemsFilter = workItemsFilter;
        this.workItemTransformer = workItemTransformer;
        this.dependencyTransformer = dependencyTransformer;
        this.defaultEstimatesApplier = defaultEstimatesApplier;
    }

    public BacklogTransformer(ITimeTransformer timeTransformer, SchedulingConfig schedulingConfig) {
        this(new PriorizedWorkItemsProvider(), new WorkItemTransformer(timeTransformer, schedulingConfig), new DependencyDefinitionTransformer(), new DefaultEstimatesApplier());
    }

    public IBacklog transformBacklog(SchedulingPlan plan, TeamsTransformationResult teamTransformationResult, ITimePlan timePlan, IProcessingDefinition processingDefinition) throws NoEstimatedWorkItemsDefinedException {
        LOGGER.debug("transform work items: %s", Joiner.on((String)",").join(plan.getWorkItems()));
        List<? extends SchedulingWorkItem> allWorkItems = this.defaultEstimatesApplier.decorateUnestimatedLeafItems(plan.getWorkItems(), plan.getPlanConfiguration().getDefaultStoryEstimate(), plan.getPlanConfiguration().getDefaultEpicEstimate());
        List<SchedulingWorkItem> sortedAndEstimatedItems = this.workItemsFilter.getValidSortedWorkItems(allWorkItems);
        if (sortedAndEstimatedItems.isEmpty()) {
            LOGGER.warn("no estimated work items available", new Object[0]);
            throw new NoEstimatedWorkItemsDefinedException();
        }
        HashSet violations = Sets.newHashSet();
        Map<SchedulingWorkItem, Set<SchedulingWorkItem>> transitivePrerequisitesMap = TransformationUtils.calculateTransitivePrerequisites(Sets.newHashSet(plan.getWorkItems()), plan.getWorkItems());
        violations.addAll(this.cylceViolationDetector.createCycleViolations(transitivePrerequisitesMap));
        HashBiMap itemMapping = HashBiMap.create((int)sortedAndEstimatedItems.size());
        int priority = 0;
        for (SchedulingWorkItem workItem : sortedAndEstimatedItems) {
            WorkItemTransformationResult transformationResult = this.workItemTransformer.transform(workItem, priority++, this.releaseTimeCalculator.getTransitiveEarliestStart(workItem, transitivePrerequisitesMap.get(workItem), plan), timePlan, processingDefinition, teamTransformationResult);
            if (!transformationResult.getViolations().isEmpty()) {
                LOGGER.info("found violation for work item %s", workItem);
                violations.addAll(transformationResult.getViolations());
                continue;
            }
            itemMapping.put(transformationResult.getProcessingItem().get(), (Object)workItem);
        }
        violations.addAll(this.createDependencyViolations(violations, transitivePrerequisitesMap, sortedAndEstimatedItems));
        AnnotatedResult<IDependencyDefinition> dependencyDefinition = this.dependencyTransformer.createDependencyDefinition(this.filterValidMapping((BiMap<IProcessingItem, SchedulingWorkItem>)itemMapping, violations), plan.getWorkItems(), timePlan);
        Backlog backlog = Backlog.createInstance(dependencyDefinition.getResult(), violations, dependencyDefinition.getWarnings());
        return backlog;
    }

    private BiMap<IProcessingItem, SchedulingWorkItem> filterValidMapping(BiMap<IProcessingItem, SchedulingWorkItem> mapping, Set<IScheduleViolation> violations) {
        HashBiMap filtered = HashBiMap.create((int)mapping.size());
        Set<String> violationIds = RmIdentifiableUtils.getIds(violations);
        for (Map.Entry entry : mapping.entrySet()) {
            if (violationIds.contains(((IProcessingItem)entry.getKey()).getId())) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        return filtered;
    }

    private Set<IScheduleViolation> createDependencyViolations(Set<IScheduleViolation> scheduleViolations, Map<SchedulingWorkItem, Set<SchedulingWorkItem>> transitivePrerequisites, Collection<SchedulingWorkItem> items) {
        HashSet dependencyViolations = Sets.newHashSet();
        Set<String> violationIds = RmIdentifiableUtils.getIds(scheduleViolations);
        for (SchedulingWorkItem item : items) {
            Set<SchedulingWorkItem> prerequisites = transitivePrerequisites.get(item);
            Set<String> prereqIds = RmIdentifiableUtils.getIds(prerequisites);
            if (Sets.intersection(violationIds, prereqIds).isEmpty()) continue;
            DependencyViolation scheduleViolation = new DependencyViolation(item.getId());
            dependencyViolations.add(scheduleViolation);
        }
        return dependencyViolations;
    }
}

