/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.SchedulingWorkItemWithDefaultEstimate;
import java.util.List;

class DefaultEstimatesApplier {
    DefaultEstimatesApplier() {
    }

    List<? extends SchedulingWorkItem> decorateUnestimatedLeafItems(List<? extends SchedulingWorkItem> items, final Double defaultStoryEstimate, final Double defaultEpicEstimate) {
        return Lists.newArrayList((Iterable)Iterables.transform(items, (Function)new Function<SchedulingWorkItem, SchedulingWorkItem>(){

            public SchedulingWorkItem apply(SchedulingWorkItem item) {
                Integer type = item.getType();
                boolean isStory = type.equals(WorkItems.Types.STORY);
                boolean isEpic = type.equals(WorkItems.Types.EPIC);
                if (isStory) {
                    return DefaultEstimatesApplier.this.decorateIfUnestimatedLeafItem(item, defaultStoryEstimate);
                }
                if (isEpic) {
                    return DefaultEstimatesApplier.this.decorateIfUnestimatedLeafItem(item, defaultEpicEstimate);
                }
                return item;
            }
        }));
    }

    private SchedulingWorkItem decorateIfUnestimatedLeafItem(SchedulingWorkItem item, Double defaultEstimate) {
        boolean defaultEstimateIsPresent;
        boolean itemIsChildless = item.getChildIds().isEmpty();
        boolean itemHasNoEstimate = !item.getTotalEstimate().isPresent() && item.getStageEstimates().isEmpty() && item.getSkillEstimates().isEmpty();
        boolean bl = defaultEstimateIsPresent = defaultEstimate != null;
        if (itemIsChildless && itemHasNoEstimate && defaultEstimateIsPresent) {
            return new SchedulingWorkItemWithDefaultEstimate(item, defaultEstimate);
        }
        return item;
    }
}

