/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.rm.jpo.scheduling.util.function.BoundDiscreteBooleanFunction;
import com.atlassian.rm.jpo.scheduling.util.function.MutableBoundBooleanFunction;
import com.atlassian.rm.jpo.scheduling.util.function.MutableBoundDiscreteBooleanFunction;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.IntervalUtils;
import java.util.List;

class AbsenceFunctionCreator {
    private final ITimeTransformer timeTransformer;

    public AbsenceFunctionCreator(ITimeTransformer timeTransformer) {
        this.timeTransformer = timeTransformer;
    }

    BoundDiscreteBooleanFunction createAbsenceFunction(List<? extends SchedulingInterval> absences, List<? extends SchedulingInterval> filteredPresences, Optional<? extends SchedulingInterval> maxOpenPresenceFunction) {
        List<? extends SchedulingInterval> filteredAbsenceIntervals = IntervalUtils.filterValidTimelyIntervals(absences, this.timeTransformer.getInstant(0));
        if (maxOpenPresenceFunction.isPresent()) {
            return this.createAbsenceWithOpenPresence(filteredAbsenceIntervals, filteredPresences, (SchedulingInterval)maxOpenPresenceFunction.get());
        }
        if (filteredAbsenceIntervals.isEmpty()) {
            return null;
        }
        int functionStart = this.getNullSafeEarliestStartTimeStepNotEmptyAbsences(filteredAbsenceIntervals);
        int functionEnd = this.getNullSafeLatestEndTimeStepNotEmptyAbsences(filteredAbsenceIntervals);
        MutableBoundBooleanFunction function = MutableBoundBooleanFunction.create(functionStart, functionEnd, false);
        for (SchedulingInterval schedulingInterval : filteredAbsenceIntervals) {
            int absenceStart = this.getSafeStartTimeStep(schedulingInterval);
            int absenceEnd = this.getEndStartTimeStep(schedulingInterval);
            function.setIn(absenceStart, absenceEnd, true);
        }
        return function;
    }

    private MutableBoundDiscreteBooleanFunction createAbsenceWithOpenPresence(List<? extends SchedulingInterval> filteredAbsenceIntervals, List<? extends SchedulingInterval> filteredPresences, SchedulingInterval unboundedPresence) {
        int functionEnd = this.getNullSafeLatestEndTimeStep(filteredAbsenceIntervals, unboundedPresence);
        if (functionEnd < 0) {
            return null;
        }
        MutableBoundBooleanFunction function = MutableBoundBooleanFunction.create(0, functionEnd, true);
        for (SchedulingInterval schedulingInterval : filteredPresences) {
            int presenceStart = IntervalUtils.getNullSafeStartTime(schedulingInterval, this.timeTransformer);
            int presenceEnd = this.getNullSafeEnd(schedulingInterval, functionEnd);
            function.setIn(presenceStart, presenceEnd, false);
        }
        for (SchedulingInterval schedulingInterval : filteredAbsenceIntervals) {
            int absenceStart = this.getSafeStartTimeStep(schedulingInterval);
            int absenceEnd = this.getEndStartTimeStep(schedulingInterval);
            function.setIn(absenceStart, absenceEnd, true);
        }
        return function;
    }

    private int getNullSafeEnd(SchedulingInterval presence, int functionEnd) {
        Long endDate = presence.getEndDate();
        if (endDate == null) {
            return functionEnd;
        }
        int endDateTimeStep = this.timeTransformer.getTimestep(endDate);
        return Math.min(endDateTimeStep, functionEnd);
    }

    private int getSafeStartTimeStep(SchedulingInterval interval) {
        long startMs = interval.getStartDate();
        if (this.timeTransformer.getInstant(0) > startMs) {
            return 0;
        }
        int start = this.timeTransformer.getTimestep(startMs);
        return start;
    }

    private int getEndStartTimeStep(SchedulingInterval interval) {
        long endMs = interval.getEndDate();
        if (this.timeTransformer.getInstant(0) > endMs) {
            return 0;
        }
        int start = this.timeTransformer.getTimestep(endMs);
        return start;
    }

    private int getNullSafeLatestEndTimeStep(List<? extends SchedulingInterval> absenceIntervals, SchedulingInterval maxOpenPresenceFunction) {
        if (absenceIntervals.isEmpty()) {
            return IntervalUtils.getNullSafeStartTime(maxOpenPresenceFunction, this.timeTransformer) - 1;
        }
        int latestEnd = -1;
        for (SchedulingInterval schedulingInterval : absenceIntervals) {
            latestEnd = Math.max(latestEnd, this.getEndStartTimeStep(schedulingInterval));
        }
        latestEnd = Math.max(latestEnd, IntervalUtils.getNullSafeStartTime(maxOpenPresenceFunction, this.timeTransformer) - 1);
        return latestEnd;
    }

    private int getNullSafeLatestEndTimeStepNotEmptyAbsences(List<? extends SchedulingInterval> intervals) {
        int latestEnd = -1;
        for (SchedulingInterval schedulingInterval : intervals) {
            latestEnd = Math.max(latestEnd, this.getEndStartTimeStep(schedulingInterval));
        }
        return latestEnd;
    }

    private int getNullSafeEarliestStartTimeStepNotEmptyAbsences(List<? extends SchedulingInterval> intervals) {
        int earliestStart = Integer.MAX_VALUE;
        for (SchedulingInterval schedulingInterval : intervals) {
            earliestStart = Math.min(earliestStart, this.getSafeStartTimeStep(schedulingInterval));
        }
        return earliestStart;
    }
}

