/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.IInterval;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
class IntervalUtils {
    IntervalUtils() {
    }

    static <T extends SchedulingInterval> Optional<T> getMaxOpenInterval(List<T> intervals) {
        if (intervals == null) {
            return Optional.absent();
        }
        SchedulingInterval function = null;
        for (SchedulingInterval interval : intervals) {
            if (interval.getEndDate() != null) continue;
            if (interval.getStartDate() == null) {
                return Optional.of((Object)interval);
            }
            if (function != null && interval.getStartDate() >= function.getStartDate()) continue;
            function = interval;
        }
        return Optional.fromNullable(function);
    }

    static <T extends IInterval> List<T> getOpenIntervals(List<T> intervals) {
        if (intervals == null) {
            return Lists.newArrayList();
        }
        ArrayList rightOpenIntervals = Lists.newArrayList();
        for (IInterval interval : intervals) {
            if (interval.getEndDate() != null) continue;
            rightOpenIntervals.add(interval);
        }
        return rightOpenIntervals;
    }

    static <T extends SchedulingInterval> List<T> filterValidTimelyIntervals(List<T> intervals, long zeroInstant) {
        if (intervals == null) {
            return Lists.newArrayList();
        }
        ArrayList filtered = Lists.newArrayList();
        for (SchedulingInterval interval : intervals) {
            Long startDate;
            Long endDate = interval.getEndDate();
            if (endDate != null && endDate < zeroInstant || (startDate = interval.getStartDate()) != null && endDate != null && startDate > endDate) continue;
            filtered.add(interval);
        }
        return filtered;
    }

    static <T extends SchedulingInterval> int getNullSafeEarliestStartTimeStep(List<T> intervals, ITimeTransformer timeTransformer) {
        if (intervals == null || intervals.isEmpty()) {
            return 0;
        }
        int minStart = Integer.MAX_VALUE;
        for (SchedulingInterval presence : intervals) {
            int timestep = IntervalUtils.getNullSafeStartTime(presence, timeTransformer);
            minStart = Math.min(minStart, timestep);
        }
        return minStart;
    }

    static <T extends SchedulingInterval> int getNullSafeStartTime(T interval, ITimeTransformer timeTransformer) {
        Long startDate = interval.getStartDate();
        if (startDate == null) {
            return 0;
        }
        int timestep = timeTransformer.getTimestep(Math.max(timeTransformer.getInstant(0), startDate));
        return timestep;
    }

    static <T extends SchedulingInterval> Optional<T> getFirstRightOpenInterval(List<T> intervals) {
        for (SchedulingInterval interval : intervals) {
            if (interval.getEndDate() != null) continue;
            return Optional.of((Object)interval);
        }
        return Optional.absent();
    }

    static <T extends SchedulingInterval> Optional<Integer> getMaxClosedIntervalEnd(Collection<T> intervals, ITimeTransformer timeTransformer) {
        Integer maxEnd = null;
        for (SchedulingInterval interval : intervals) {
            Long endDate = interval.getEndDate();
            if (endDate == null) continue;
            int endStep = timeTransformer.getTimestep(endDate);
            maxEnd = RmUtils.getOptionalMax(endStep, (Optional<Integer>)Optional.fromNullable(maxEnd));
        }
        return Optional.fromNullable(maxEnd);
    }

    static <T extends SchedulingInterval> Optional<Integer> getHighestPrioOpenIntervalStart(List<T> intervals, ITimeTransformer timeTransformer) {
        for (SchedulingInterval interval : intervals) {
            Long endDate = interval.getEndDate();
            if (endDate != null) continue;
            int startTime = IntervalUtils.getNullSafeStartTime(interval, timeTransformer);
            return Optional.of((Object)startTime);
        }
        return Optional.absent();
    }
}

