/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourceAvailability;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourcePresence;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.StepWiseWorkSlotFunction;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.ResourceAvailabilityCreator;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.ResourcePresenceFunctionCreator;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WorkFunctionCreator {
    private static final Log LOGGER = Log.with(WorkFunctionCreator.class);
    private final ResourcePresenceFunctionCreator presenceCreator;
    private final ResourceAvailabilityCreator availabilityCreator;

    WorkFunctionCreator(ResourcePresenceFunctionCreator presenceCreator, ResourceAvailabilityCreator availabilityCreator) {
        this.presenceCreator = presenceCreator;
        this.availabilityCreator = availabilityCreator;
    }

    public WorkFunctionCreator(ITimeTransformer timeTransformer, TimeStepPresenceFunction workDayFunction) {
        this(new ResourcePresenceFunctionCreator(timeTransformer, workDayFunction), new ResourceAvailabilityCreator(timeTransformer, workDayFunction));
    }

    public Optional<IWorkSlotFunction> tryCreateWorkSlotAvailability(SchedulingResource resource, SchedulingPerson person, WorkSlotsDefinition workSlotsDefinition) {
        LOGGER.debug("create work supply function for resource: %s", resource.getId());
        Optional<IStepWiseResourcePresence> presence = this.presenceCreator.createResourcePresenceFunction(person.getPresenceIntervals(), person.getAbsenceIntervals());
        if (!presence.isPresent()) {
            LOGGER.debug("no valid presence defined", new Object[0]);
            return Optional.absent();
        }
        Optional<IStepWiseResourceAvailability> availability = this.availabilityCreator.createAvailability(resource);
        if (!availability.isPresent()) {
            LOGGER.debug("no valid availability defined", new Object[0]);
            return Optional.absent();
        }
        StepWiseWorkSlotFunction availabilityFunction = new StepWiseWorkSlotFunction((IStepWiseResourcePresence)presence.get(), (IStepWiseResourceAvailability)availability.get(), workSlotsDefinition);
        LOGGER.debug("create: %s", availability);
        return Optional.fromNullable((Object)availabilityFunction);
    }
}

