/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.point;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.ScrumSprintTransformer;
import javax.annotation.Nullable;

abstract class BasePointTeamTransformer {
    private static final Log LOGGER = Log.with(BasePointTeamTransformer.class);
    protected final ScrumSprintTransformer sprintTransformer;

    BasePointTeamTransformer(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(new ScrumSprintTransformer(timeTransformer, timeStepPresenceFunction));
    }

    BasePointTeamTransformer(ScrumSprintTransformer sprintTransformer) {
        this.sprintTransformer = sprintTransformer;
    }

    protected float getVelocity(SchedulingTeam team, @Nullable Double globalDefaultVelocity) {
        Double teamVelocity = team.getVelocity();
        if (teamVelocity != null) {
            return teamVelocity.floatValue();
        }
        if (globalDefaultVelocity != null) {
            LOGGER.debug("use default velocity for team: %s", team);
            return globalDefaultVelocity.floatValue();
        }
        LOGGER.warn("no valid team and default velocity found - use fallback velocity", new Object[0]);
        return 40.0f;
    }
}

