/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.point;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.LinearTeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;

public abstract class LinearTeamVelocityFunctionFactory {
    private static final Log LOGGER = Log.with(LinearTeamVelocityFunction.class);

    private LinearTeamVelocityFunctionFactory() {
    }

    public static LinearTeamVelocityFunction createInstance(SchedulingTeam team, float velocity, WorkSlotsDefinition workSlotsDefinition, TimeStepPresenceFunction presenceFunction) {
        LOGGER.debug("create instance for team: %s", team);
        float increment = LinearTeamVelocityFunctionFactory.getIncrement(team.getIncrementalAdjustment());
        return new LinearTeamVelocityFunction(velocity, increment, workSlotsDefinition, presenceFunction);
    }

    private static float getIncrement(Double increment) {
        if (increment == null) {
            return 0.0f;
        }
        return increment.floatValue();
    }
}

