/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.scrum;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroupFactory;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.ScrumSprintTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.scrum.ScrumResourceTransformer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ScrumTeamTransformer {
    private static final Log LOGGER = Log.with(ScrumTeamTransformer.class);
    private final ScrumResourceTransformer resourceTransformer;
    private final ScrumSprintTransformer sprintTransformer;

    public ScrumTeamTransformer(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(new ScrumResourceTransformer(timeTransformer, timeStepPresenceFunction), new ScrumSprintTransformer(timeTransformer, timeStepPresenceFunction));
    }

    ScrumTeamTransformer(ScrumResourceTransformer resourceTransformer, ScrumSprintTransformer scrumSprintTransformer) {
        this.resourceTransformer = resourceTransformer;
        this.sprintTransformer = scrumSprintTransformer;
    }

    public Optional<IResourceGroup> tryCreateResourceGroup(SchedulingTeam team, IResourceTypeMapping resourceTypeMapping, SchedulingPlan plan) {
        LOGGER.debug("create resource group from team: %s", team);
        if (team.getResources() == null) {
            LOGGER.debug("resources is null - ignored", new Object[0]);
            return Optional.absent();
        }
        WorkSlotsDefinition slotDefinition = this.sprintTransformer.createWorkSlotDefinition(team, plan.getPlanConfiguration().getGlobalSprintLength());
        Set<IWorkResource> workResources = this.createWorkResources(team.getResources(), plan, team, resourceTypeMapping, slotDefinition);
        if (workResources.isEmpty()) {
            LOGGER.debug("team has no members - ignored", new Object[0]);
            return Optional.absent();
        }
        ResourceGroup resourceGroup = ResourceGroupFactory.createResourceGroup(team.getId(), workResources, slotDefinition, null, team.getSortOrder().toString(), (Boolean)Optional.fromNullable((Object)plan.getPlanConfiguration().getStrictStageDivision()).or((Object)true));
        LOGGER.debug("created resource group: %s", resourceGroup);
        return Optional.of((Object)resourceGroup);
    }

    private Set<IWorkResource> createWorkResources(List<? extends SchedulingResource> resources, SchedulingPlan plan, SchedulingTeam team, IResourceTypeMapping resourceTypeMapping, WorkSlotsDefinition workSlotsDefinition) {
        HashSet transformedResources = Sets.newHashSetWithExpectedSize((int)resources.size());
        for (SchedulingResource schedulingResource : resources) {
            Optional<IWorkResource> transformed = this.resourceTransformer.tryCreateWorkResource(schedulingResource, (SchedulingPerson)plan.getPerson(schedulingResource.getPersonId()).get(), team, resourceTypeMapping, workSlotsDefinition);
            if (!transformed.isPresent()) continue;
            transformedResources.add(transformed.get());
        }
        return transformedResources;
    }
}

