/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.estimate;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import java.util.HashMap;
import java.util.Map;

final class ProgressTools {
    public static final String JIRA_ISSUE_STAGE = "jira-issue-stage-";

    ProgressTools() {
    }

    static Map<String, ProgressData> getProgressPerStage(IWorkItem workItem, Map<String, ProgressData> linkProgressMap) {
        HashMap progressPerStage = Maps.newHashMap();
        for (IExtensionLink link : workItem.getExtensionLinks()) {
            ProgressData stageProgress;
            if (!ProgressTools.isStageLink(link) || (stageProgress = linkProgressMap.get(link.getExtensionLink())) == null) continue;
            progressPerStage.put(ProgressTools.getStageId(link), stageProgress);
        }
        return progressPerStage;
    }

    private static boolean isStageLink(IExtensionLink link) {
        return link.getExtensionKey().startsWith(JIRA_ISSUE_STAGE);
    }

    private static String getStageId(IExtensionLink link) {
        return link.getExtensionKey().replace(JIRA_ISSUE_STAGE, "").trim();
    }
}

