/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.HierarchicalJiraIssueData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.AbstractFullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ExtensionLinkProgress;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FailSafeCustomFieldReader;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ProgressUtils;
import java.util.Map;
import java.util.Set;

class UnweightedFieldFullProgressCalculator
extends AbstractFullProgressCalculator {
    private final FailSafeCustomFieldReader customFieldReader;

    UnweightedFieldFullProgressCalculator(FailSafeCustomFieldReader customFieldReader, HierarchicalJiraIssueData issueHierarchy) {
        super(issueHierarchy);
        this.customFieldReader = customFieldReader;
    }

    @Override
    protected ProgressData createProgress(String root, Map<String, ProgressData> treeMap) {
        Optional<Double> points = this.customFieldReader.getCustomFieldValueForIssueId(root);
        if (points.isPresent()) {
            return this.createEstimatedProgress(root, (Double)points.get(), treeMap);
        }
        return this.createNotEstimatedProgress(root, treeMap);
    }

    private ProgressData createEstimatedProgress(String root, double estimate, Map<String, ProgressData> treeMap) {
        Set<ProgressData> childProgresses = this.getChildProgresses(root, treeMap);
        double sum = ProgressUtils.computeTotalSum(childProgresses) + estimate;
        boolean done = this.issueHierarchy.getIssueData(root).isDone();
        double percentage = 0.0;
        if (done) {
            percentage = 1.0;
        }
        return new ExtensionLinkProgress(percentage, sum, done);
    }

    private ProgressData createNotEstimatedProgress(String root, Map<String, ProgressData> treeMap) {
        Set<ProgressData> childProgresses = this.getChildProgresses(root, treeMap);
        boolean done = this.issueHierarchy.getIssueData(root).isDone();
        if (childProgresses.isEmpty()) {
            double percentage = 0.0;
            if (done) {
                percentage = 1.0;
            }
            return new ExtensionLinkProgress(percentage, 0.0, done);
        }
        return ProgressUtils.getCombinedProgress(childProgresses, done, true);
    }
}

