/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.jira.common.components.utils.JiraSyncUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class SyncVersionUtils {
    private final JiraSyncUtil jiraSyncUtil;

    public SyncVersionUtils(JiraSyncUtil jiraSyncUtil) {
        this.jiraSyncUtil = jiraSyncUtil;
    }

    public Set<Long> getFixVersionIdsInIssueProject(VersionManager versionManager, Long issueProjectId, Set<String> releaseIds, List<ViolationMessage> errorMessages) throws Exception {
        HashSet fixVersionIds = Sets.newHashSet();
        ArrayList releaseLinks = Lists.newArrayList();
        for (String release : releaseIds) {
            releaseLinks.addAll(this.jiraSyncUtil.getReleaseLinks(release));
        }
        for (IExtensionLink link : releaseLinks) {
            try {
                Long versionId = Long.parseLong(link.getExtensionLink());
                Version version = versionManager.getVersion(versionId);
                if (version == null || !version.getProjectId().equals(issueProjectId)) continue;
                fixVersionIds.add(version.getId());
            }
            catch (Exception ex) {
                errorMessages.add(new ViolationMessage.Impl("warning", "sync-invalid-release-link"));
            }
        }
        return fixVersionIds;
    }

    public static Set<String> getTransitiveReleaseIds(IWorkItem workItem, @Nullable RestSchedulingSolution solution) {
        Set<String> releaseIds = SyncVersionUtils.getSelfReleaseIds(workItem, solution);
        List<? extends IWorkItem> children = workItem.getChildren();
        for (IWorkItem iWorkItem : children) {
            Set<String> childReleaseIds = SyncVersionUtils.getTransitiveReleaseIds(iWorkItem, solution);
            releaseIds.addAll(childReleaseIds);
        }
        return releaseIds;
    }

    private static Set<String> getSelfReleaseIds(IWorkItem workItem, @Nullable RestSchedulingSolution solution) {
        Set<String> plannedReleases;
        if (workItem.getReleaseId() != null) {
            return Sets.newHashSet((Object[])new String[]{workItem.getReleaseId()});
        }
        if (solution != null && (plannedReleases = solution.getReleaseIdsForWorkItem(workItem.getId())) != null) {
            return plannedReleases;
        }
        return Sets.newHashSet();
    }

    public static Set<Long> getSetFixVersionsForIssue(MutableIssue issue) {
        HashSet allFixVersions = Sets.newHashSet();
        for (Version version : issue.getFixVersions()) {
            allFixVersions.add(version.getId());
        }
        return allFixVersions;
    }
}

