/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.pocketknife.api.querydsl.ConnectionProvider;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.jira.common.components.issues.IssueEventWrapper;
import com.radiantminds.roadmap.jira.common.components.issues.JiraIssueLinkAccessor;
import com.radiantminds.roadmap.jira.common.components.issues.JiraIssueSynchronizer;
import com.radiantminds.roadmap.jira.common.components.issues.ProcessedIssueEvent;
import com.radiantminds.roadmap.jira.common.components.issues.SyncableFields;
import com.radiantminds.roadmap.jira.common.components.sync.SynchronizationFlagHandler;
import com.radiantminds.roadmap.jira.common.components.utils.JiraSyncUtil;

public class JiraIssueEventHandler {
    private static final Log LOGGER = Log.with(JiraIssueEventHandler.class);
    private final JiraIssueLinkAccessor jiraIssueLinkAccessor;
    private final JiraIssueSynchronizer jiraIssueSynchronizer;
    private final SyncableFields syncableFields;

    public JiraIssueEventHandler(SynchronizationFlagHandler flagHandler, ConnectionProvider connectionProvider, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioPlanPersistence planPersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, WorkItemExtension workItemExtension, ApplicationProperties applicationProperties, SyncableFields syncableFields) {
        this.syncableFields = syncableFields;
        this.jiraIssueLinkAccessor = new JiraIssueLinkAccessor(extensionLinkPersistence);
        JiraSyncUtil jiraSyncUtil = new JiraSyncUtil(extensionLinkPersistence);
        this.jiraIssueSynchronizer = new JiraIssueSynchronizer(flagHandler, connectionProvider, workItemPersistence, estimatePersistence, planPersistence, extensionLinkPersistence, workItemExtension, applicationProperties, this.jiraIssueLinkAccessor, jiraSyncUtil);
    }

    public void handleIssueUpdatedEvent(IssueEventWrapper issueEvent) {
        try {
            ProcessedIssueEvent issueEventWrapper = new ProcessedIssueEvent(issueEvent, this.syncableFields);
            this.jiraIssueSynchronizer.onJiraIssueUpdated(issueEventWrapper.getIssueKey(), issueEventWrapper.getChangedFields());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to handle issue updated event.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.ERROR);
        }
    }

    public void handleIssueDeleted(String key) {
        try {
            this.jiraIssueLinkAccessor.removeAllLinksForIssue(key);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to handle issue delete event.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.ERROR);
        }
    }
}

