/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.timeline;

import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.CallbackSkeleton;
import org.javasimon.callback.timeline.StopwatchTimeline;

public class TimelineCallback
extends CallbackSkeleton {
    public static final String TIMELINE_ATTRIBUTE_NAME = "timeline";
    private final String timelineAttributeName;
    private final int timelineCapacity;
    private final long timeRangeWidth;

    public TimelineCallback(String timelineAttributeName, int timelineCapacity, long timeRangeWidth) {
        this.timelineAttributeName = timelineAttributeName;
        this.timelineCapacity = timelineCapacity;
        this.timeRangeWidth = timeRangeWidth;
    }

    public TimelineCallback(int timelineCapacity, long timeRangeWidth) {
        this(TIMELINE_ATTRIBUTE_NAME, timelineCapacity, timeRangeWidth);
    }

    public TimelineCallback() {
        this(6, 360000L);
    }

    private StopwatchTimeline getStopwatchTimeline(Stopwatch stopwatch) {
        return (StopwatchTimeline)stopwatch.getAttribute(this.timelineAttributeName);
    }

    public void onSimonCreated(Simon simon) {
        if (simon instanceof Stopwatch) {
            simon.setAttribute(this.timelineAttributeName, new StopwatchTimeline(this.timelineCapacity, this.timeRangeWidth));
        }
    }

    public void onStopwatchAdd(Stopwatch stopwatch, Split split, StopwatchSample sample) {
        StopwatchTimeline timeline = this.getStopwatchTimeline(stopwatch);
        if (timeline != null) {
            timeline.addSplit(split);
        }
    }

    public void onStopwatchStop(Split split, StopwatchSample sample) {
        StopwatchTimeline timeline = this.getStopwatchTimeline(split.getStopwatch());
        if (timeline != null) {
            timeline.addSplit(split);
        }
    }
}

