/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class PreconditionUtils {
    private PreconditionUtils() {
    }

    public static float checkArgumentRealPercentage(float argument) {
        Preconditions.checkArgument((Doubles.compare((double)argument, (double)0.0) >= 0 ? 1 : 0) != 0, (Object)"percentage value must be greater equal 0");
        Preconditions.checkArgument((Doubles.compare((double)argument, (double)1.0) <= 0 ? 1 : 0) != 0, (Object)"percentage value must be less equal 1");
        return argument;
    }

    public static void checkValuesLargerZero(Collection<? extends Number> numbers) {
        for (Number number : numbers) {
            if (!(number.floatValue() <= 0.0f)) continue;
            Preconditions.checkArgument((boolean)false, (Object)"value must be greater zero");
        }
    }

    public static Integer checkArgumentNullableNonNegative(Integer value) {
        Preconditions.checkArgument((value == null || value >= 0 ? 1 : 0) != 0, (Object)"argument is not a nullable Integer");
        return value;
    }

    public static void checkArgumentNullableInterval(Integer start, Integer end) {
        if (start == null || end == null) {
            return;
        }
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0);
    }
}

