/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.config.properties.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtil.class);

    public static int getIntProperty(ApplicationProperties applicationProperties, String propertyKey, int defaultValue) {
        return PropertiesUtil.getIntPropertyInternal(applicationProperties, propertyKey, defaultValue, true);
    }

    public static int getIntPropertyNoErrorLogIfUnavailableOrNotParsable(ApplicationProperties applicationProperties, String propertyKey, int defaultValue) {
        return PropertiesUtil.getIntPropertyInternal(applicationProperties, propertyKey, defaultValue, false);
    }

    private static int getIntPropertyInternal(ApplicationProperties applicationProperties, String propertyKey, int defaultValue, boolean shouldLogError) {
        try {
            return Integer.parseInt(applicationProperties.getDefaultBackedString(propertyKey));
        }
        catch (Exception e) {
            if (shouldLogError) {
                log.error("Exception whilst trying to find value for property '" + propertyKey + "'. Defaulting to " + defaultValue + ". " + String.valueOf(e));
            }
            return defaultValue;
        }
    }

    public static long getLongProperty(ApplicationProperties applicationProperties, String propertyKey, long defaultValue) {
        return PropertiesUtil.getLongPropertyInternal(applicationProperties, propertyKey, defaultValue, true);
    }

    public static long getLongPropertyNoErrorLogIfUnavailableOrNotParsable(ApplicationProperties applicationProperties, String propertyKey, long defaultValue) {
        return PropertiesUtil.getLongPropertyInternal(applicationProperties, propertyKey, defaultValue, false);
    }

    public static long getLongPropertyInternal(ApplicationProperties applicationProperties, String propertyKey, long defaultValue, boolean shouldLogError) {
        try {
            return Long.parseLong(applicationProperties.getDefaultBackedString(propertyKey));
        }
        catch (Exception e) {
            if (shouldLogError) {
                log.error("Exception whilst trying to find value for property '" + propertyKey + "'. Defaulting to " + defaultValue + ". " + String.valueOf(e));
            }
            return defaultValue;
        }
    }

    public static double getDoubleProperty(ApplicationProperties applicationProperties, String propertyKey, double defaultValue) {
        return PropertiesUtil.getDoublePropertyInternal(applicationProperties, propertyKey, defaultValue, true);
    }

    public static double getDoublePropertyNoErrorLogIfUnavailableOrNotParsable(ApplicationProperties applicationProperties, String propertyKey, double defaultValue) {
        return PropertiesUtil.getDoublePropertyInternal(applicationProperties, propertyKey, defaultValue, false);
    }

    private static double getDoublePropertyInternal(ApplicationProperties applicationProperties, String propertyKey, double defaultValue, boolean shouldLogError) {
        try {
            return Double.parseDouble(applicationProperties.getDefaultBackedString(propertyKey));
        }
        catch (Exception e) {
            if (shouldLogError) {
                log.error("Exception whilst trying to find value for property '" + propertyKey + "'. Defaulting to " + defaultValue + ". " + String.valueOf(e));
            }
            return defaultValue;
        }
    }

    public static boolean getBooleanProperty(ApplicationProperties applicationProperties, String propertyKey, boolean defaultValue) {
        try {
            String value = applicationProperties.getDefaultBackedString(propertyKey);
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
            log.error("Invalid value for '" + propertyKey + "'. Defaulting to " + defaultValue + ". IllegalArgumentException: " + value);
        }
        catch (Exception e) {
            log.error("Exception whilst trying to find value for property '" + propertyKey + "'. Defaulting to " + defaultValue + ". " + String.valueOf(e));
        }
        return defaultValue;
    }

    private PropertiesUtil() {
        throw new AssertionError((Object)"cannot instantiate");
    }
}

