/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.remotelink;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ObjectMapperFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public abstract class AbstractRemoteEntityLinkService {
    protected static final String MSG_IS_REQUIRED = "admin.common.words.is.required";
    protected static final String MSG_DOES_NOT_EXIST = "remotelink.service.does.not.exist";
    protected static final String MSG_ERROR_CREATING = "remotelink.service.error.creating";
    protected static final String MSG_ERROR_UPDATING = "remotelink.service.error.updating";
    protected static final String MSG_ERROR_REMOVING = "remotelink.service.error.removing";
    protected static final String MSG_FIELD_TOO_LONG = "remotelink.service.field.too.long";
    protected static final String MSG_GLOBAL_ID = "remotelink.service.globalid";
    protected static final String MSG_TITLE = "remotelink.service.title";
    protected static final String MSG_URL = "remotelink.service.url";
    protected static final String MSG_APPLICATION_TYPE = "remotelink.service.applicationtype";
    protected static final String MSG_APPLICATION_NAME = "remotelink.service.applicationname";
    protected static final String MSG_INVALID_JSON = "remotelink.service.invalid.json";
    protected static final String MSG_INVALID_URI = "remotelink.service.invalid.uri";
    protected final String entityName;
    protected final JsonEntityPropertyManager jsonEntityPropertyManager;

    protected AbstractRemoteEntityLinkService(String entityName, JsonEntityPropertyManager jsonEntityPropertyManager) {
        this.entityName = entityName;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    @Nullable
    protected String getEntityPropertyValue(@Nonnull Long entityId, @Nonnull String globalId) {
        EntityProperty property = this.jsonEntityPropertyManager.get(this.entityName, entityId, globalId);
        return property != null ? property.getValue() : null;
    }

    @Nonnull
    protected String putEntityPropertyValue(@Nonnull Long entityId, @Nullable String globalId, @Nonnull String json) {
        Assertions.notNull("entityId", entityId);
        Assertions.notNull("json", json);
        globalId = this.fixGlobalId(globalId, json);
        this.jsonEntityPropertyManager.put(this.entityName, entityId, globalId, json);
        return globalId;
    }

    protected String putEntityPropertyDryRun(@Nonnull Long entityId, @Nullable String globalId, @Nonnull String json) {
        Assertions.notNull("entityId", entityId);
        Assertions.notNull("json", json);
        globalId = this.fixGlobalId(globalId, json);
        this.jsonEntityPropertyManager.putDryRun(this.entityName, globalId, json);
        return globalId;
    }

    protected static void verifyNotNull(ErrorCollection errors, I18nHelper i18n, String field, Object value) {
        if (value == null) {
            errors.addError(field, i18n.getText(MSG_IS_REQUIRED, field), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    protected static void verifyNotBlank(ErrorCollection errors, I18nHelper i18n, String field, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            errors.addError(field, i18n.getText(MSG_IS_REQUIRED, field), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private String fixGlobalId(String globalId, String json) {
        if ((globalId = StringUtils.trimToNull((String)globalId)) == null && (globalId = StringUtils.trimToNull((String)this.getGlobalIdFromJson(json))) == null) {
            globalId = UUID.randomUUID().toString();
        }
        return globalId;
    }

    private String getGlobalIdFromJson(String json) {
        try {
            JsonNode node = ObjectMapperFactory.getObjectMapper().readTree((Reader)new StringReader(json));
            if (node == null || !node.isObject()) {
                return null;
            }
            JsonNode globalId = node.get("globalId");
            if (globalId == null || !globalId.isTextual()) {
                return null;
            }
            return globalId.asText();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("JSON validation failed: " + String.valueOf(ioe));
        }
    }
}

