/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.jira.issue.Issue;
import org.ofbiz.core.entity.GenericValue;

public class WorkRatio {
    public static long getWorkRatio(Issue issue) {
        return WorkRatio.getWorkRatio(issue.getOriginalEstimate(), issue.getTimeSpent());
    }

    public static long getWorkRatio(GenericValue issue) {
        Long originalEstimate = (Long)issue.get("timeoriginalestimate");
        Long timespent = (Long)issue.get("timespent");
        return WorkRatio.getWorkRatio(originalEstimate, timespent);
    }

    public static long getWorkRatio(Long originalEstimate, Long timespent) {
        if (originalEstimate != null) {
            if (timespent != null) {
                float timeOriginalEstimate = originalEstimate.longValue();
                float timeSpent = timespent.longValue();
                float timeRatio = timeSpent / timeOriginalEstimate;
                return (long)Math.floor(timeRatio * 100.0f);
            }
            return 0L;
        }
        return -1L;
    }

    public static String getPaddedWorkRatio(GenericValue issue) {
        String ratio = String.valueOf(WorkRatio.getWorkRatio(issue));
        return WorkRatio.getPaddedWorkRatioString(ratio);
    }

    public static String getPaddedWorkRatioString(String ratio) {
        int length = ((String)ratio).length();
        if (5 > length && !"-1".equals(ratio)) {
            for (int i = 0; i < 5 - length; ++i) {
                ratio = "0" + (String)ratio;
            }
        }
        return ratio;
    }
}

