/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;

@PublicApi
public class EntityPropertyType {
    public static final EntityPropertyType REMOTE_VERSION_LINK = new EntityPropertyType("RemoteVersionLink", "issue.remoteissuelink", "REMOTEVERLINKPROP", "issue.remoteissuelink");
    public static final Searchable ISSUE_PROPERTY = new Searchable("IssueProperty", "common.concepts.issue", "ISSUEPROP", "issue.property", 4L);
    public static final Searchable ISSUE_INTERNAL_PROPERTY = new Searchable("IssueInternalProperty", "common.concepts.issue", "ISSUEINTERNPROPERTY", "issue.internalProperty", 3L);
    public static final Searchable PROJECT_PROPERTY = new Searchable("ProjectProperty", "common.concepts.project", "PROJECTPROP", "project.property", 2L);
    public static final EntityPropertyType COMMENT_PROPERTY = new EntityPropertyType("CommentProperty", "common.concepts.comment", "COMMENTPROP", "comment.property");
    public static final EntityPropertyType CHANGE_HISTORY_PROPERTY = new EntityPropertyType("ChangeHistoryProperty", "common.concepts.changehistory", "CHANGEHISTORYPROP", "changehistory.property");
    public static final EntityPropertyType DASHBOARD_ITEM_PROPERTY = new EntityPropertyType("DashboardItemProperty", "common.concepts.dashboard.item", "DASHBOARDITEMPROP", "");
    public static final EntityPropertyType ISSUE_TYPE_PROPERTY = new EntityPropertyType("IssueTypeProperty", "common.concepts.issuetype", "ISSUETYPEPROP", "issuetype.property");
    public static final Searchable USER_PROPERTY = new Searchable("UserProperty", "common.concepts.user", "USERPROP", "", 1L);
    private final String dbEntityName;
    private final String i18nKeyForEntityName;
    private final String indexPrefix;
    private final String jqlName;
    private static final Map<String, Searchable> jqlClauseToProperty = ImmutableMap.of((Object)ISSUE_PROPERTY.getJqlName(), (Object)ISSUE_PROPERTY, (Object)ISSUE_INTERNAL_PROPERTY.getJqlName(), (Object)ISSUE_INTERNAL_PROPERTY, (Object)USER_PROPERTY.getJqlName(), (Object)USER_PROPERTY, (Object)PROJECT_PROPERTY.getJqlName(), (Object)PROJECT_PROPERTY);
    private static final Map<String, Searchable> dbNameToProperty = ImmutableMap.of((Object)ISSUE_PROPERTY.getDbEntityName(), (Object)ISSUE_PROPERTY, (Object)ISSUE_INTERNAL_PROPERTY.getDbEntityName(), (Object)ISSUE_INTERNAL_PROPERTY, (Object)USER_PROPERTY.getDbEntityName(), (Object)USER_PROPERTY, (Object)PROJECT_PROPERTY.getDbEntityName(), (Object)PROJECT_PROPERTY);

    public EntityPropertyType(String dbEntityName, String i18nKeyForEntityName, String indexPrefix, String jqlName) {
        this.dbEntityName = dbEntityName;
        this.i18nKeyForEntityName = i18nKeyForEntityName;
        this.indexPrefix = indexPrefix;
        this.jqlName = jqlName;
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public String getI18nKeyForEntityName() {
        return this.i18nKeyForEntityName;
    }

    public String getJqlName() {
        return this.jqlName;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public static boolean isJqlClause(String clauseName) {
        return clauseName != null && jqlClauseToProperty.containsKey(clauseName);
    }

    public static EntityPropertyType getEntityPropertyTypeForClause(String clauseName) {
        return jqlClauseToProperty.get(clauseName);
    }

    public static Searchable[] getSearchablePropertyTypes() {
        return jqlClauseToProperty.values().stream().collect(Collectors.toList()).toArray(new Searchable[jqlClauseToProperty.size()]);
    }

    public static Searchable getSearchablePropertyByName(String name) {
        Searchable type = dbNameToProperty.get(name);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)("Unrecognized entity property type: " + name));
        return type;
    }

    public static class Searchable
    extends EntityPropertyType {
        private final long entityPropertyTypeId;

        private Searchable(String dbEntityName, String i18nKeyForEntityName, String indexPrefix, String jqlName, long entityPropertyTypeId) {
            super(dbEntityName, i18nKeyForEntityName, indexPrefix, jqlName);
            this.entityPropertyTypeId = entityPropertyTypeId;
        }

        public long getEntityPropertyTypeId() {
            return this.entityPropertyTypeId;
        }
    }
}

