/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config;

import com.atlassian.annotations.Internal;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FieldConfigSchemeImpl
implements FieldConfigScheme {
    private static final Logger log = LoggerFactory.getLogger(FieldConfigSchemeImpl.class);
    private final Long id;
    private final String name;
    private final String description;
    private final String fieldId;
    @Nonnull
    private final Map<String, FieldConfig> configs;
    private final FieldConfigContextPersister configContextPersister;
    private final IssueTypeIdsByFieldConfigRef issueTypeIdsByFieldConfigRef = new IssueTypeIdsByFieldConfigRef();
    private final ConfigsByConfigRef configsByConfigRef = new ConfigsByConfigRef();
    private final LazyReference<List<JiraContextNode>> applicableContexts = new LazyReference<List<JiraContextNode>>(){

        protected List<JiraContextNode> create() {
            if (FieldConfigSchemeImpl.this.configContextPersister == null) {
                return Collections.emptyList();
            }
            ArrayList<JiraContextNode> applicableContexts = new ArrayList<JiraContextNode>(FieldConfigSchemeImpl.this.configContextPersister.getAllContextsForConfigScheme(FieldConfigSchemeImpl.this));
            Collections.sort(applicableContexts);
            return Collections.unmodifiableList(applicableContexts);
        }
    };

    public FieldConfigSchemeImpl(Long id, String fieldId, String name, String description, Map<String, FieldConfig> configs, FieldConfigContextPersister configContextPersister) {
        this.id = id;
        this.fieldId = fieldId;
        this.name = StringUtils.abbreviate((String)name, (int)254);
        this.description = description;
        this.configs = configs != null ? CollectionUtil.copyAsImmutableMap(configs) : Collections.emptyMap();
        this.configContextPersister = configContextPersister;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nonnull
    public Map<String, FieldConfig> getConfigs() {
        return this.configs;
    }

    @Override
    public List<JiraContextNode> getContexts() {
        return (List)this.applicableContexts.get();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    String getFieldId() {
        return this.fieldId;
    }

    @Override
    public ConfigurableField<?> getField() {
        return ComponentAccessor.getFieldManager().getConfigurableField(this.fieldId);
    }

    @Override
    public boolean isInContext(IssueContext issueContext) {
        List<JiraContextNode> contexts = this.getContexts();
        return contexts != null && contexts.stream().anyMatch(ctx -> ctx.isInContext(issueContext));
    }

    @Override
    @Nonnull
    public List<Project> getAssociatedProjectObjects() {
        return this.getContextInfo(IssueContext::getProjectObject);
    }

    @Override
    @Nonnull
    public List<Long> getAssociatedProjectIds() {
        return this.getContextInfo(IssueContext::getProjectId);
    }

    @Nonnull
    private <T> List<T> getContextInfo(Function<JiraContextNode, T> mapper) {
        List<JiraContextNode> contexts = this.getContexts();
        if (contexts.isEmpty()) {
            return Collections.emptyList();
        }
        return contexts.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    @Nonnull
    public Collection<IssueType> getAssociatedIssueTypes() {
        if (this.configs.isEmpty() || !this.isEnabled()) {
            return Collections.emptyList();
        }
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        return (Collection)this.configs.keySet().stream().map(constantsManager::getIssueType).collect(CollectorsUtil.toNewArrayListWithSizeOf(this.configs));
    }

    @Override
    @Nonnull
    public Collection<String> getAssociatedIssueTypeIds() {
        return this.isEnabled() ? this.configs.keySet() : Collections.emptyList();
    }

    @Override
    public boolean isGlobal() {
        return this.isAllProjects() && this.isAllIssueTypes();
    }

    @Override
    public boolean isAllProjects() {
        return this.getContexts().stream().anyMatch(context -> context.getProjectId() == null);
    }

    @Override
    public boolean isAllIssueTypes() {
        return this.getAssociatedIssueTypeIds().contains(null);
    }

    @Override
    public boolean isEnabled() {
        return !this.getContexts().isEmpty();
    }

    @Override
    public boolean isBasicMode() {
        return this.getIssueTypeIdsByFieldConfig().size() <= 1;
    }

    @Override
    @Nonnull
    public MultiMap getConfigsByConfig() {
        return (MultiMap)Objects.requireNonNull(this.configsByConfigRef.get());
    }

    @Override
    @Nonnull
    public Map<FieldConfig, Collection<String>> getIssueTypeIdsByFieldConfig() {
        return (Map)Objects.requireNonNull(this.issueTypeIdsByFieldConfigRef.get());
    }

    @Override
    @Nullable
    public FieldConfig getOneAndOnlyConfig() {
        Map<FieldConfig, Collection<String>> issueTypeIdsByFieldConfig = this.getIssueTypeIdsByFieldConfig();
        if (issueTypeIdsByFieldConfig.size() == 1) {
            return issueTypeIdsByFieldConfig.keySet().iterator().next();
        }
        log.warn("There is not exactly one config for this scheme ({}). Configs are {}.", (Object)this.id, issueTypeIdsByFieldConfig);
        return null;
    }

    FieldConfigContextPersister getFieldConfigContextPersister() {
        return this.configContextPersister;
    }

    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof FieldConfigScheme && this.equalTo((FieldConfigScheme)o);
    }

    private boolean equalTo(@Nonnull FieldConfigScheme other) {
        return Objects.equals(this.id, other.getId()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.description, other.getDescription());
    }

    public int compareTo(Object obj) {
        FieldConfigScheme o = (FieldConfigScheme)obj;
        return new CompareToBuilder().append((Object)this.id, (Object)o.getId()).append((Object)this.name, (Object)o.getName()).append((Object)this.description, (Object)o.getDescription()).toComparison();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description);
    }

    private class ConfigsByConfigRef
    extends LazyReference<MultiMap> {
        private ConfigsByConfigRef() {
        }

        protected MultiMap create() {
            MultiValueMap result = MultiValueMap.decorate(new HashMap(), HashSet.class);
            FieldConfigSchemeImpl.this.getConfigs().forEach((arg_0, arg_1) -> ConfigsByConfigRef.lambda$create$0((MultiMap)result, arg_0, arg_1));
            return result;
        }

        private static /* synthetic */ void lambda$create$0(MultiMap result, String issueTypeId, FieldConfig fieldConfig) {
            result.put((Object)fieldConfig, (Object)issueTypeId);
        }
    }

    private class IssueTypeIdsByFieldConfigRef
    extends LazyReference<Map<FieldConfig, Collection<String>>> {
        private IssueTypeIdsByFieldConfigRef() {
        }

        protected Map<FieldConfig, Collection<String>> create() {
            LinkedHashMultimap result = LinkedHashMultimap.create();
            FieldConfigSchemeImpl.this.getConfigs().forEach((arg_0, arg_1) -> IssueTypeIdsByFieldConfigRef.lambda$create$0((Multimap)result, arg_0, arg_1));
            return result.asMap();
        }

        private static /* synthetic */ void lambda$create$0(Multimap result, String issueTypeId, FieldConfig fieldConfig) {
            result.put((Object)fieldConfig, (Object)issueTypeId);
        }
    }
}

