/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.issuefieldoption;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public final class IssueFieldOptionScope {
    public static final IssueFieldOptionScope GLOBAL = new IssueFieldOptionScope(Collections.emptyList());
    private final Set<Long> projects;

    public boolean contains(IssueFieldOptionScope scope) {
        return this.equals(GLOBAL) || Sets.difference(scope.getProjects(), this.getProjects()).isEmpty();
    }

    public static IssueFieldOptionScope projects(Long ... projects) {
        return IssueFieldOptionScope.projects(Arrays.asList(projects));
    }

    public static IssueFieldOptionScope projects(Collection<Long> projects) {
        Preconditions.checkArgument((projects.size() > 0 ? 1 : 0) != 0);
        return new IssueFieldOptionScope(projects);
    }

    private IssueFieldOptionScope(Iterable<Long> projects) {
        this.projects = ImmutableSet.copyOf(projects);
    }

    public Set<Long> getProjects() {
        return this.projects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IssueFieldOptionScope data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueFieldOptionScope that = (IssueFieldOptionScope)o;
        return Objects.equals(this.getProjects(), that.getProjects());
    }

    public int hashCode() {
        return Objects.hash(this.getProjects());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projects", this.getProjects()).toString();
    }

    public static final class Builder {
        private Set<Long> projects = Sets.newHashSet();

        private Builder() {
        }

        private Builder(IssueFieldOptionScope initialData) {
            this.projects = Sets.newHashSet(initialData.getProjects());
        }

        public Builder setProjects(Set<Long> projects) {
            this.projects = projects != null ? projects : Collections.emptySet();
            return this;
        }

        public Builder addProject(Long project) {
            this.projects.add(project);
            return this;
        }

        public Builder addProjects(Iterable<Long> projects) {
            for (Long project : projects) {
                this.addProject(project);
            }
            return this;
        }

        public Builder addEntity(String entityId, Type entityType) {
            switch (entityType) {
                case PROJECT: {
                    this.addProject(Long.valueOf(entityId));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported type: " + (Object)((Object)entityType));
                }
            }
            return this;
        }

        public IssueFieldOptionScope build() {
            return new IssueFieldOptionScope(this.projects);
        }
    }

    public static enum Type {
        PROJECT;

    }
}

