/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.util;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.project.version.VersionBuilder;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class VersionHelperBean {
    public static final Long UNKNOWN_VERSION_ID = new Long(-1L);
    public static final Long UNRELEASED_VERSION_ID = new Long(-2L);
    public static final Long RELEASED_VERSION_ID = new Long(-3L);
    private VersionManager versionManager;
    private final PermissionManager permissionManager;
    @Deprecated
    public static final String NEW_VERSION_RREFIX = "nv_";

    @Deprecated
    public VersionHelperBean(VersionManager versionManager) {
        this.versionManager = versionManager;
        this.permissionManager = ComponentAccessor.getPermissionManager();
    }

    public VersionHelperBean(VersionManager versionManager, PermissionManager permissionManager) {
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
    }

    public boolean validateVersionIds(Collection versionIds, ErrorCollection errorCollection, I18nHelper i18n, String fieldId) {
        boolean valid = true;
        if (versionIds != null) {
            if (versionIds.size() > 1 && versionIds.contains(UNKNOWN_VERSION_ID)) {
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.noneselectedwithother"), ErrorCollection.Reason.VALIDATION_FAILED);
                valid = false;
            }
            for (Object o : versionIds) {
                Long l = this.getVersionIdAsLong(o);
                if (l >= -1L) continue;
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.releasedunreleasedselected"), ErrorCollection.Reason.VALIDATION_FAILED);
                valid = false;
            }
        }
        return valid;
    }

    private List<Long> sanitizeVersionIds(Collection<?> magicVersionIds) {
        return magicVersionIds.stream().map(this::getVersionIdAsLong).filter(Objects::nonNull).filter(id -> id != -1L).distinct().collect(Collectors.toList());
    }

    private Multimap<Long, Version> versionCollectionToMap(Collection<Version> versions) {
        return (Multimap)versions.stream().collect(CollectorsUtil.toUnmodifiableSetMultiMap(Version::getId, v -> v));
    }

    public void validateVersionForProject(Collection<?> versionIds, Project project, ErrorCollection errorCollection, I18nHelper i18n, String fieldId) {
        if (versionIds != null && project != null) {
            Long projectId = project.getId();
            Multimap<Long, Version> existingVersions = this.versionCollectionToMap(this.versionManager.getVersions(this.sanitizeVersionIds(versionIds)));
            StringJoiner sj = new StringJoiner(", ");
            for (Object versionId : versionIds) {
                Long id = this.getVersionIdAsLong(versionId);
                if (id != null && id == -1L) {
                    return;
                }
                Collection versions = existingVersions.get((Object)id);
                if (versions.isEmpty()) {
                    errorCollection.addError(fieldId, i18n.getText("issue.field.versions.invalid.version.id", id), ErrorCollection.Reason.VALIDATION_FAILED);
                    return;
                }
                versions.stream().filter(version -> !version.getProjectId().equals(projectId)).forEach(version -> sj.add(version.getName() + "(" + version.getId() + ")"));
            }
            if (sj.length() > 0) {
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.versions.not.valid.for.project", sj.toString(), project.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    public void validateVersionsToCreate(ApplicationUser user, I18nHelper i18n, Project project, String fieldId, Set<String> newVersionNames, ErrorCollection errorCollection) {
        if (this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user)) {
            VersionService versionService = this.getVersionService();
            for (String version : newVersionNames) {
                VersionBuilder builder = versionService.newVersionBuilder().projectId(project.getId()).name(version);
                VersionService.VersionBuilderValidationResult result = versionService.validateCreate(user, builder);
                if (result.isValid()) continue;
                ErrorCollection errors = result.getErrorCollection();
                for (String errorMsg : errors.getErrorMessages()) {
                    errorCollection.addError(fieldId, errorMsg, ErrorCollection.Reason.VALIDATION_FAILED);
                }
                errorCollection.addError(fieldId, errors.getErrors().get("name"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else {
            String bad = StringUtils.join(newVersionNames, (String)"");
            if (!StringUtils.isEmpty((String)bad)) {
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.invalid.version.id", bad), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    public List<Version> createNewVersions(Long projectId, Set<String> versionsToAdd) {
        ArrayList newVersions = Lists.newArrayList();
        for (String version : versionsToAdd) {
            newVersions.add(this.createOrGetVersion(projectId, version));
        }
        return newVersions;
    }

    private Version createOrGetVersion(Long projectId, String versionName) {
        Version existingVersion = this.versionManager.getVersion(projectId, versionName);
        if (existingVersion == null) {
            try {
                return this.versionManager.createVersion(versionName, null, null, projectId, null);
            }
            catch (CreateException e) {
                throw new RuntimeException(e);
            }
        }
        return existingVersion;
    }

    private Long getVersionIdAsLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            return Longs.tryParse((String)((String)o));
        }
        return null;
    }

    @VisibleForTesting
    VersionService getVersionService() {
        return ComponentAccessor.getComponentOfType(VersionService.class);
    }
}

