/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.AbstractProjectAttributeClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.util.JqlVersionPredicate;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.webresource.impl.support.Tuple;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VersionClauseContextFactory
extends AbstractProjectAttributeClauseContextFactory<Version>
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final VersionResolver versionResolver;

    public VersionClauseContextFactory(JqlOperandResolver jqlOperandResolver, VersionResolver versionResolver, PermissionManager permissionManager) {
        super(new VersionIndexInfoResolver(versionResolver), jqlOperandResolver, permissionManager);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
    }

    private Tuple<Map<Long, Version>, Boolean> getSpecifiedVersion(final Collection<QueryLiteral> literals) {
        if (literals == null) {
            return new Tuple(Collections.emptyMap(), (Object)false);
        }
        Multimap<Long, Version> versionsById = this.versionResolver.get(literals.stream().map(QueryLiteral::getLongValue).filter(Objects::nonNull).collect(Collectors.toList()));
        LazyReference<Multimap<String, Version>> longVersionsByName = new LazyReference<Multimap<String, Version>>(){

            protected Multimap<String, Version> create() throws Exception {
                return VersionClauseContextFactory.this.versionResolver.get(literals.stream().map(QueryLiteral::getLongValue).filter(Objects::nonNull).map(Object::toString).distinct().collect(Collectors.toList()));
            }
        };
        Multimap<String, Version> versionsByName = this.versionResolver.get(literals.stream().map(QueryLiteral::getStringValue).filter(Objects::nonNull).collect(Collectors.toList()));
        LazyReference<Multimap<Long, Version>> stringVersionsById = new LazyReference<Multimap<Long, Version>>(){

            protected Multimap<Long, Version> create() throws Exception {
                return VersionClauseContextFactory.this.versionResolver.get(literals.stream().map(ql -> Longs.tryParse((String)ql.getStringValue())).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        };
        return this.getAssociatedVersions(literals, versionsById, longVersionsByName, versionsByName, stringVersionsById);
    }

    private Tuple<Map<Long, Version>, Boolean> getAssociatedVersions(Collection<QueryLiteral> literals, Multimap<Long, Version> versionsById, LazyReference<Multimap<String, Version>> longVersionsByNameFallback, Multimap<String, Version> versionsByName, LazyReference<Multimap<Long, Version>> stringVersionsByIdFallback) {
        HashMap specifiedVersions = Maps.newHashMapWithExpectedSize((int)literals.size());
        boolean containsEmpty = false;
        for (QueryLiteral literal : literals) {
            if (literal.isEmpty()) {
                containsEmpty = true;
                continue;
            }
            if (literal.getLongValue() != null) {
                this.getAssociatedLongVersion(literal, versionsById, longVersionsByNameFallback).forEach(version -> specifiedVersions.put(version.getId(), version));
                continue;
            }
            if (literal.getStringValue() == null) continue;
            this.getAssociatedStringVersion(literal, versionsByName, stringVersionsByIdFallback).forEach(version -> specifiedVersions.put(version.getId(), version));
        }
        return new Tuple((Object)specifiedVersions, (Object)containsEmpty);
    }

    private Collection<Version> getAssociatedLongVersion(QueryLiteral literal, Multimap<Long, Version> versionsById, LazyReference<Multimap<String, Version>> longVersionsByNameFallback) {
        Collection versions = versionsById.get((Object)literal.getLongValue());
        if (versions == null || versions.isEmpty()) {
            versions = Optional.ofNullable(((Multimap)longVersionsByNameFallback.get()).get((Object)literal.getLongValue().toString())).orElse(Collections.emptyList());
        }
        return versions;
    }

    private Collection<Version> getAssociatedStringVersion(QueryLiteral literal, Multimap<String, Version> versionsByName, LazyReference<Multimap<Long, Version>> stringVersionsByIdFallback) {
        Long versionId;
        Collection versions = versionsByName.get((Object)literal.getStringValue());
        if ((versions == null || versions.isEmpty()) && (versionId = Longs.tryParse((String)literal.getStringValue())) == null) {
            versions = Optional.ofNullable(((Multimap)stringVersionsByIdFallback.get()).get((Object)versionId)).orElse(Collections.emptyList());
        }
        return versions;
    }

    @Override
    ClauseContext getContextFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        Tuple<Map<Long, Version>, Boolean> specifiedVersionsTuple = this.getSpecifiedVersion(literals);
        Map specifiedVersions = (Map)specifiedVersionsTuple.getFirst();
        boolean containsEmpty = (Boolean)specifiedVersionsTuple.getLast();
        if (!specifiedVersions.isEmpty()) {
            Set<ProjectIssueTypeContext> contexts = this.isRelationalOperator(operator) ? this.getRelationalOperatorContext(specifiedVersions, operator, searcher) : (this.isNegationOperator(operator) ? this.getNegationOperatorContext(specifiedVersions, searcher) : this.getDefaultOperatorContext(specifiedVersions, searcher));
            if (containsEmpty) {
                contexts.add(ProjectIssueTypeContextImpl.createGlobalContext());
            }
            return new ClauseContextImpl(contexts);
        }
        return ClauseContextImpl.createGlobalClauseContext();
    }

    private Set<ProjectIssueTypeContext> getRelationalOperatorContext(Map<Long, Version> specifiedVersions, Operator operator, ApplicationUser searcher) {
        HashSet<Long> checkedProjects = new HashSet<Long>();
        HashSet<ProjectIssueTypeContext> contexts = new HashSet<ProjectIssueTypeContext>();
        HashMap<Long, JqlVersionPredicate> temporaryPredicates = new HashMap<Long, JqlVersionPredicate>(specifiedVersions.size());
        for (Version version : this.versionResolver.getAll()) {
            if (checkedProjects.contains(version.getProjectId())) continue;
            for (Version specifiedVersion : specifiedVersions.values()) {
                temporaryPredicates.computeIfAbsent(specifiedVersion.getId(), id -> new JqlVersionPredicate(operator, specifiedVersion));
                if (!((JqlVersionPredicate)temporaryPredicates.get(specifiedVersion.getId())).evaluate(version)) continue;
                checkedProjects.add(version.getProjectId());
                contexts.addAll(this.getContextsForProject(searcher, version.getProject()));
            }
        }
        return contexts;
    }

    private Set<ProjectIssueTypeContext> getNegationOperatorContext(Map<Long, Version> specifiedVersions, ApplicationUser searcher) {
        return this.processOperatorContext(this.versionResolver.getAll().stream().filter(version -> specifiedVersions.get(version.getId()) == null), searcher);
    }

    private Set<ProjectIssueTypeContext> getDefaultOperatorContext(Map<Long, Version> specifiedVersions, ApplicationUser searcher) {
        return this.processOperatorContext(specifiedVersions.values().stream(), searcher);
    }

    private Set<ProjectIssueTypeContext> processOperatorContext(Stream<Version> versionStream, ApplicationUser searcher) {
        return versionStream.map(Version::getProject).distinct().map(project -> this.getContextsForProject(searcher, (Project)project)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator) || OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

