/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.annotations.PublicApi;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@PublicApi
public class VersionResolver
implements NameResolver<Version> {
    private final VersionManager versionManager;

    public VersionResolver(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public List<String> getIdsFromName(String name) {
        return Optional.ofNullable(this.getIdsFromNames(Collections.singletonList(name)).get((Object)name)).map(collection -> new ArrayList(collection)).orElse(Collections.emptyList());
    }

    @Override
    public boolean nameExists(String name) {
        Assertions.notNull("name", name);
        Collection<Version> versions = this.versionManager.getVersionsByName(name);
        return !versions.isEmpty();
    }

    @Override
    public boolean idExists(Long id) {
        Assertions.notNull("id", id);
        return this.versionManager.getVersion(id) != null;
    }

    @Override
    public Multimap<String, String> getIdsFromNames(Collection<String> names) {
        return (Multimap)this.versionManager.getVersionsForNames(names).entries().stream().collect(CollectorsUtil.toUnmodifiableSetMultiMap(Map.Entry::getKey, entry -> ((Version)entry.getValue()).getId().toString()));
    }

    @Override
    public Set<Long> getExistingIds(Collection<Long> ids) {
        return this.versionManager.getVersions(new LinkedList<Long>(ids)).stream().map(Version::getId).collect(Collectors.toSet());
    }

    @Override
    public Version get(Long id) {
        return this.versionManager.getVersion(id);
    }

    public Multimap<String, Version> get(Collection<String> names) {
        return this.versionManager.getVersionsForNames(names);
    }

    public Multimap<Long, Version> get(List<Long> ids) {
        return (Multimap)this.versionManager.getVersions(ids).stream().collect(CollectorsUtil.toUnmodifiableSetMultiMap(Version::getId, Function.identity()));
    }

    @Override
    public Collection<Version> getAll() {
        return this.versionManager.getAllVersions();
    }
}

