/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.http.ReadOnlyHttpServletRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public final class AuthenticationData {
    private final ReadOnlyHttpServletRequest request;
    private final ApplicationUser user;

    public static AuthenticationData requestAndUser(@Nonnull HttpServletRequest request, @Nullable ApplicationUser user) {
        return new AuthenticationData(new ReadOnlyHttpServletRequest(request), user);
    }

    private AuthenticationData(ReadOnlyHttpServletRequest request, ApplicationUser user) {
        this.request = (ReadOnlyHttpServletRequest)((Object)Preconditions.checkNotNull((Object)((Object)request)));
        this.user = user;
    }

    public ReadOnlyHttpServletRequest getRequest() {
        return this.request;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationData that = (AuthenticationData)o;
        return Objects.equals((Object)this.getRequest(), (Object)that.getRequest()) && Objects.equals(this.getUser(), that.getUser());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getRequest(), this.getUser()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.getRequest()).add("user", (Object)this.getUser()).toString();
    }
}

