/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.sharing.search.ProjectShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.type.ShareType;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class SharedEntitySearchEvent {
    private final SharedEntitySearchParameters searchParameters;

    public SharedEntitySearchEvent(@Nonnull SharedEntitySearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    public boolean isByName() {
        return !StringUtils.isEmpty((String)this.searchParameters.getName());
    }

    public boolean isByDescription() {
        return !StringUtils.isEmpty((String)this.searchParameters.getDescription());
    }

    public boolean isFavourite() {
        return this.searchParameters.getFavourite() == null ? false : this.searchParameters.getFavourite();
    }

    public boolean isByUser() {
        return !StringUtils.isEmpty((String)this.searchParameters.getUserName());
    }

    public boolean isByGlobalShare() {
        return this.searchParameters.getShareTypeParameter() == null || this.isByShareType(ShareType.Name.GLOBAL);
    }

    public boolean isByGroupShare() {
        return this.isByShareType(ShareType.Name.GROUP);
    }

    public boolean isByProjectShare() {
        return this.isByShareType(ShareType.Name.PROJECT) && !this.isUsingRoleParameter();
    }

    public boolean isByProjectRoleShare() {
        return this.isByShareType(ShareType.Name.PROJECT) && this.isUsingRoleParameter();
    }

    public boolean isAscendingSort() {
        return this.searchParameters.isAscendingSort();
    }

    public String getSortColumn() {
        return this.searchParameters.getSortColumn().name();
    }

    public String getSearchContext() {
        return this.searchParameters.getEntitySearchContext() != null ? this.searchParameters.getEntitySearchContext().name() : null;
    }

    private boolean isByShareType(ShareType.Name shareTypeName) {
        ShareTypeSearchParameter shareTypeParameter = this.searchParameters.getShareTypeParameter();
        return shareTypeParameter != null && shareTypeName.equals(shareTypeParameter.getType());
    }

    private boolean isUsingRoleParameter() {
        ProjectShareTypeSearchParameter parameter = (ProjectShareTypeSearchParameter)this.searchParameters.getShareTypeParameter();
        return parameter.getRoleId() != null;
    }
}

