/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonAutoDetect;

public class ApplicationLinkControl
extends BackdoorControl<ApplicationLinkControl> {
    public ApplicationLinkControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String addApplicationLink(String type, String name, String url) throws JSONException {
        JSONObject query = this.prepareAddApplinkQuery(type, name, url);
        return (String)this.createResource().header("Content-Type", (Object)"application/json").put(String.class, (Object)query.toString());
    }

    public String addApplicationLinkAndReturnId(String type, String name, String url) throws JSONException {
        JSONObject query = this.prepareAddApplinkQuery(type, name, url);
        String response = (String)((WebResource.Builder)this.createResource().type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).put(String.class, (Object)query.toString());
        return this.parseApplinkIdFromJsonPutResponse(response);
    }

    private String parseApplinkIdFromJsonPutResponse(String jsonPutResponse) throws JSONException {
        URL resourceUrl;
        JSONObject responseObj = new JSONObject(jsonPutResponse);
        String href = responseObj.getJSONArray("resources-created").getJSONObject(0).getString("href");
        try {
            resourceUrl = new URL(href);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        String path = resourceUrl.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public void deleteLink(String linkId) {
        this.createResource().path(linkId).queryParam("reciprocate", "false").delete();
    }

    public List<ApplicationLink> getApplicationLinks() {
        return ((ApplicationLinksResponse)this.createResource().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ApplicationLinksResponse.class)).getApplicationLinks();
    }

    @Override
    protected WebResource createResource() {
        WebResource resource = this.resourceRoot(this.rootPath).path("rest").path("applinks").path("2.0").path("applicationlink");
        resource.addFilter((ClientFilter)new BackdoorControl.BackdoorLoggingFilter());
        resource.addFilter((ClientFilter)new BackdoorControl.JsonMediaTypeFilter());
        return resource;
    }

    private JSONObject prepareAddApplinkQuery(String type, String name, String url) throws JSONException {
        JSONObject query = new JSONObject();
        query.put("name", (Object)name);
        query.put("rpcUrl", (Object)url);
        query.put("displayUrl", (Object)url);
        query.put("typeId", (Object)type);
        return query;
    }

    @JsonAutoDetect
    public static class ApplicationLinksResponse {
        private List<ApplicationLink> applicationLinks;

        public List<ApplicationLink> getApplicationLinks() {
            return this.applicationLinks;
        }

        public void setApplicationLinks(List<ApplicationLink> applicationLinks) {
            this.applicationLinks = applicationLinks;
        }
    }

    @JsonAutoDetect
    public static class ApplicationLink {
        private String id;
        private String typeId;
        private String name;
        private String displayUrl;
        private String rpcUrl;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayUrl() {
            return this.displayUrl;
        }

        public void setDisplayUrl(String displayUrl) {
            this.displayUrl = displayUrl;
        }

        public String getRpcUrl() {
            return this.rpcUrl;
        }

        public void setRpcUrl(String rpcUrl) {
            this.rpcUrl = rpcUrl;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

