/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.CustomFieldDefaultValue;
import com.atlassian.jira.testkit.beans.CustomFieldRequest;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class CustomFieldsControl
extends BackdoorControl<CustomFieldsControl> {
    public CustomFieldsControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String createCustomField(String name, String description, String type, String searcherKey) {
        CustomFieldRequest request = new CustomFieldRequest();
        request.name = name;
        request.description = description;
        request.type = type;
        request.searcherKey = searcherKey;
        CustomFieldResponse response = (CustomFieldResponse)this.createResource().path("customFields/create").post(CustomFieldResponse.class, (Object)request);
        return response.id;
    }

    public void updateCustomField(String id, String name, String description, String searcherKey) {
        CustomFieldRequest request = new CustomFieldRequest();
        request.name = name;
        request.description = description;
        request.searcherKey = searcherKey;
        this.createResource().path("customFields").path(id).put((Object)request);
    }

    public void deleteCustomField(String customFieldId) {
        this.createResource().path("customFields").path("delete").path(customFieldId).delete();
    }

    public void addOption(String customFieldId, String optionValue) {
        this.createResource().path("customFields/addOption").path(customFieldId).post((Object)optionValue);
    }

    public void enableOption(Long customFieldOptionId) {
        this.createResource().path("customFields/enableOption").path(customFieldOptionId.toString()).put();
    }

    public void disableOption(Long customFieldOptionId) {
        this.createResource().path("customFields/disableOption").path(customFieldOptionId.toString()).put();
    }

    public void deleteOption(String customFieldId, String optionValue) {
        this.createResource().path("customFields/deleteOption").path(customFieldId).delete((Object)optionValue);
    }

    public List<CustomFieldResponse> getCustomFields() {
        return this.getCustomFields(false);
    }

    public List<CustomFieldResponse> getCustomFields(boolean config) {
        return (List)this.createResource().path("customFields").path("get").queryParam("config", String.valueOf(config)).get((GenericType)new GenericType<List<CustomFieldResponse>>(){});
    }

    public CustomFieldResponse getCustomField(String id) {
        return this.getCustomField(id, false);
    }

    public CustomFieldResponse getCustomField(String id, boolean config) {
        return (CustomFieldResponse)this.createResource().path("customFields").path(id).queryParam("config", String.valueOf(config)).get((GenericType)new GenericType<CustomFieldResponse>(){});
    }

    public long createCustomFieldContext(String customFieldId, List<Long> projectIds, List<Long> issueTypeIds) {
        WebResource r = this.createResource().path("customFields").path("addCustomFieldContext").queryParam("customFieldId", String.valueOf(customFieldId));
        for (Long projectId : projectIds) {
            r = r.queryParam("projectIds", String.valueOf(projectId));
        }
        for (Long id : issueTypeIds) {
            r = r.queryParam("issueTypeIds", String.valueOf(id));
        }
        return (Long)((ClientResponse)r.post(ClientResponse.class)).getEntity(Long.class);
    }

    public void deleteCustomFieldContext(String contextId) {
        WebResource r = this.createResource().path("customFields").path("deleteCustomFieldContext").queryParam("contextId", String.valueOf(contextId));
        r.delete(ClientResponse.class);
    }

    public void setDefaultValueForContext(Long contextId, Object value) {
        CustomFieldDefaultValue request = new CustomFieldDefaultValue();
        request.value = value == null ? null : value.toString();
        this.createResource().path("customFields").path("defaultValueForContext").path(contextId.toString()).put((Object)request);
    }

    public String getDefaultValueForContext(Long contextId) {
        return (String)this.createResource().path("customFields").path("defaultValueForContext").path(contextId.toString()).get(String.class);
    }
}

