/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonAutoDetect;

public class DashboardControl
extends BackdoorControl<DashboardControl> {
    private static final GenericType<List<Dashboard>> DASHBOARD_LIST_GENERIC_TYPE = new GenericType<List<Dashboard>>(){};
    private static final GenericType<Dashboard> DASHBOARD_GENERIC_TYPE = new GenericType<Dashboard>(){};

    public DashboardControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Optional<Dashboard> getDashboard(long id) {
        return this.getDashboard(id, null);
    }

    public Optional<Dashboard> getDashboard(long id, @Nullable String username) {
        try {
            WebResource resource = this.createResource().path("dashboard").path(Long.toString(id));
            if (username != null) {
                resource.queryParam("username", username);
            }
            return Optional.of(resource.get(DASHBOARD_GENERIC_TYPE));
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse() != null && Response.Status.NOT_FOUND.getStatusCode() == ex.getResponse().getStatus()) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    public List<Dashboard> getOwnedDashboard(String username) {
        return (List)this.createResource().path("dashboard").path("my").queryParam("username", username).get(DASHBOARD_LIST_GENERIC_TYPE);
    }

    public DashboardControl emptySystemDashboard() {
        this.createResource().path("dashboard").path("emptySystemDashboard").get(String.class);
        return this;
    }

    public Dashboard createDashboard(String username, String name, String description, Layout layout, boolean global, boolean favorite) {
        WebResource resource = this.createResource().path("dashboard").path("add").queryParam("username", username).queryParam("name", name).queryParam("global", global ? "true" : "false").queryParam("favorite", favorite ? "true" : "false");
        if (description != null) {
            resource = resource.queryParam("description", description);
        }
        if (layout != null) {
            resource = resource.queryParam("layout", layout.name());
        }
        return (Dashboard)resource.get(Dashboard.class);
    }

    public void deleteDashboard(String username, Long id) {
        WebResource resource = this.createResource().path("dashboard").path("delete").queryParam("username", username).queryParam("id", Long.toString(id));
        resource.get(String.class);
    }

    public Dashboard updateDashboard(String username, Long id, String name, String ownername, String description, String shareGroupName, boolean favorite) {
        WebResource resource = this.createResource().path("dashboard").path("update").queryParam("username", username).queryParam("id", Long.toString(id)).queryParam("ownername", ownername).queryParam("favorite", favorite ? "true" : "false");
        if (description != null) {
            resource = resource.queryParam("description", description);
        }
        if (name != null) {
            resource = resource.queryParam("name", name);
        }
        if (shareGroupName != null) {
            resource = resource.queryParam("shareGroupName", shareGroupName);
        }
        return (Dashboard)resource.get(Dashboard.class);
    }

    @JsonAutoDetect
    public static class Dashboard {
        private long id;
        private String name;
        private String owner;
        private String description;
        private long favouriteCount;
        private boolean favourite;

        public Long getId() {
            return this.id;
        }

        public Dashboard setId(Long id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Dashboard setName(String name) {
            this.name = name;
            return this;
        }

        public String getOwner() {
            return this.owner;
        }

        public Dashboard setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Dashboard setDescription(String description) {
            this.description = description;
            return this;
        }

        public long getFavouriteCount() {
            return this.favouriteCount;
        }

        public Dashboard setFavouriteCount(long favouriteCount) {
            this.favouriteCount = favouriteCount;
            return this;
        }

        public boolean isFavourite() {
            return this.favourite;
        }

        public Dashboard setFavourite(boolean favourite) {
            this.favourite = favourite;
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

