/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class IssueTypeControl
extends BackdoorControl<IssueTypeControl> {
    private static final GenericType<List<IssueType>> LIST_GENERIC_TYPE = new GenericType<List<IssueType>>(){};

    public IssueTypeControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public IssueType createIssueType(String name) {
        return this.createIssueType(name, "/images/icons/genericissue.gif");
    }

    public IssueType createIssueType(String name, String iconURL) {
        IssueType issueType = new IssueType();
        issueType.setName(name);
        issueType.setIconUrl(iconURL);
        issueType.setSubtask(false);
        return this.createIssueType(issueType);
    }

    public IssueType createIssueType(IssueType issueType) {
        return (IssueType)this.createIssueTypeResource().post(IssueType.class, (Object)issueType);
    }

    public List<IssueType> getIssueTypes() {
        return (List)this.createIssueTypeResource().get(LIST_GENERIC_TYPE);
    }

    public List<IssueType> getIssueTypesForProject(String projectIdOrKey) {
        return (List)this.createIssueTypeResource(projectIdOrKey).get(LIST_GENERIC_TYPE);
    }

    public void deleteIssueType(long id) {
        this.createIssueTypeResource().path(String.valueOf(id)).delete();
    }

    private WebResource createIssueTypeResource() {
        return this.createResource().path("issueType");
    }

    private WebResource createIssueTypeResource(String projectIdOrKey) {
        return this.createIssueTypeResource().path("project").path(projectIdOrKey);
    }

    public static class IssueType {
        private String id;
        private String description;
        private String iconUrl;
        private String name;
        private boolean subtask;
        private String nameTranslation;
        private String descTranslation;

        public IssueType() {
        }

        public IssueType(String id, String name, String description, String iconUrl, boolean subtask) {
            this(id, name, description, iconUrl, subtask, null, null);
        }

        public IssueType(String id, String name, String description, String iconUrl, boolean subtask, String nameTranslation, String descTranslation) {
            this.id = id;
            this.description = description;
            this.iconUrl = iconUrl;
            this.name = name;
            this.subtask = subtask;
            this.nameTranslation = nameTranslation;
            this.descTranslation = descTranslation;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSubtask() {
            return this.subtask;
        }

        public void setSubtask(boolean subtask) {
            this.subtask = subtask;
        }

        public String getNameTranslation() {
            return this.nameTranslation;
        }

        public void setNameTranslation(String nameTranslation) {
            this.nameTranslation = nameTranslation;
        }

        public String getDescTranslation() {
            return this.descTranslation;
        }

        public void setDescTranslation(String descTranslation) {
            this.descTranslation = descTranslation;
        }
    }
}

