/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.AnalyticsEnabled;
import com.atlassian.jira.testkit.client.restclient.AnalyticsReportBean;
import com.atlassian.jira.testkit.client.restclient.AnalyticsReportConfig;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.MediaType;

public class AnalyticsClient
extends RestApiClient<AnalyticsClient> {
    public AnalyticsClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public void acknowledgePolicy() {
        this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)AnalyticsClient.this.createResource().path("config").path("acknowledge").type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class);
            }
        });
    }

    public void disable() {
        this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)AnalyticsClient.this.createResource().path("config").path("enable").type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)new AnalyticsEnabled(false));
            }
        });
    }

    public void enable() {
        this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)AnalyticsClient.this.createResource().path("config").path("enable").type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)new AnalyticsEnabled(true));
            }
        });
    }

    public void startCapturing() {
        this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)AnalyticsClient.this.createResource().path("report").type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)new AnalyticsReportConfig(true));
            }
        });
    }

    public void stopCapturing() {
        this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)AnalyticsClient.this.createResource().path("report").type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)new AnalyticsReportConfig(false));
            }
        });
    }

    public void clearCaptured() {
        this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)AnalyticsClient.this.createResource().path("report").delete(ClientResponse.class);
            }
        });
    }

    public Response<AnalyticsReportBean> getReport(final ReportMode reportMode) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)AnalyticsClient.this.createResource().path("report").queryParam("mode", reportMode.alias).get(ClientResponse.class);
            }
        }, AnalyticsReportBean.class);
    }

    @Override
    protected WebResource createResource() {
        return this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("analytics").path("1.0");
    }

    public static enum ReportMode {
        BTF("btf_processed"),
        CLOUD("ondemand_processed"),
        RAW("unprocessed");

        final String alias;

        private ReportMode(String alias) {
            this.alias = alias;
        }
    }
}

