/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.beans.IssueSecuritySchemeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.IssueSecuritySchemes;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;

public class IssueSecuritySchemeClient
extends RestApiClient<IssueSecuritySchemeClient> {
    public IssueSecuritySchemeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Response<IssueSecuritySchemes> getAllSecuritySchemes() throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueSecuritySchemeClient.this.resource().get(ClientResponse.class);
            }
        }, IssueSecuritySchemes.class);
    }

    public Response<IssueSecuritySchemeBean> get(final long schemeId) throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueSecuritySchemeClient.this.issueSecuritySchemeWithID(schemeId).get(ClientResponse.class);
            }
        }, IssueSecuritySchemeBean.class);
    }

    public Response<IssueSecuritySchemeBean> getForProject(final String projectIdOrKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)IssueSecuritySchemeClient.this.createResource().path("project").path(projectIdOrKey).path("issuesecuritylevelscheme").get(ClientResponse.class);
            }
        }, IssueSecuritySchemeBean.class);
    }

    private WebResource issueSecuritySchemeWithID(long schemeId) {
        return this.resource().path(String.valueOf(schemeId));
    }

    private WebResource resource() {
        return this.createResource().path("issuesecurityschemes");
    }
}

