/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.atlassian.jira.testkit.client.restclient.UserPickerResults;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;

public class UserClient
extends RestApiClient<UserClient> {
    public UserClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public User get(String username, User.Expand ... expand) {
        return this.get(username, false, expand);
    }

    public User get(String username, boolean includeDeleted, User.Expand ... expand) {
        return (User)this.userWithUsername(username, includeDeleted, UserClient.setOf(User.Expand.class, (Enum[])expand)).get(User.class);
    }

    public User getByKey(String key, User.Expand ... expand) {
        return this.getByKey(key, false, expand);
    }

    public User getByKey(String key, boolean includeDeleted, User.Expand ... expand) {
        return (User)this.userWithKey(key, includeDeleted, UserClient.setOf(User.Expand.class, (Enum[])expand)).get(User.class);
    }

    public List<User> searchAssignable(String query, String issueKey, String startAt, String maxResults) {
        WebResource resource = this.getSearchAssignableResource(query, issueKey, startAt, maxResults);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public List<User> multiProjectSearchAssignable(String query, String projectKeys, String startAt, String maxResults) {
        WebResource resource = this.getMultiProjectSearchAssignableResource(query, projectKeys, startAt, maxResults);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public List<User> searchViewableIssue(String query, String issueKey, String startAt, String maxResults) {
        WebResource resource = this.getSearchViewableIssueResource(query, issueKey, startAt, maxResults);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public List<User> search(String query, String startAt, String maxResults) {
        WebResource resource = this.getSearchResource(query, startAt, maxResults, null, null);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public List<User> search(String query, String startAt, String maxResults, Boolean includeActive, Boolean includeInactive) {
        WebResource resource = this.getSearchResource(query, startAt, maxResults, includeActive, includeInactive);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public UserPickerResults picker(String query, String maxResults) {
        WebResource resource = this.getPickerResource(query, maxResults);
        return (UserPickerResults)resource.get(UserPickerResults.class);
    }

    public UserBean createUser(UserBean userBean) {
        return (UserBean)((WebResource.Builder)this.createResource().path("user").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(UserBean.class, (Object)userBean);
    }

    public UserBean updateEmail(String userName, String newEmail) {
        return this.updateUser(userName, UserBean.builder().setEmailAddress(newEmail).build());
    }

    public UserBean updateDisplayName(String userName, String displayName) {
        return this.updateUser(userName, UserBean.builder().setDisplayName(displayName).build());
    }

    public UserBean updatePassword(String userName, String password) {
        return this.updateUser(userName, UserBean.builder().setPassword(password).build());
    }

    public UserBean updateName(String userName, String newName) {
        return this.updateUser(userName, UserBean.builder().setName(newName).build());
    }

    public UserBean updateUser(String userName, UserBean updateBean) {
        return (UserBean)((WebResource.Builder)this.createResource().path("user").queryParam("username", userName).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).put(UserBean.class, (Object)updateBean);
    }

    public void addUserToApplication(String userName, String applicationKey) {
        this.applicationAccessResource(userName, applicationKey).post();
    }

    public List<User> searchByPermission(String query, String permissions, String issueKey, String projectKey, String startAt, String maxResults) {
        WebResource resource = this.getSearchByPermissionResource(query, permissions, issueKey, projectKey, startAt, maxResults);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public Response searchByPermissionResponse(String query, String permissions, String issueKey, String projectKey, String startAt, String maxResults) {
        WebResource resource = this.getSearchByPermissionResource(query, permissions, issueKey, projectKey, startAt, maxResults);
        return this.getResponse(resource);
    }

    public Response addUserToApplicationResponse(String username, String applicationKey) {
        return this.postResponse(this.applicationAccessResource(username, applicationKey));
    }

    public void removeUserFromApplication(String username, String applicationKey) {
        this.applicationAccessResource(username, applicationKey).delete();
    }

    public Response removeUserFromApplicationResponse(String username, String applicationKey) {
        return this.deleteResponse(this.applicationAccessResource(username, applicationKey));
    }

    public WebResource applicationAccessResource(String username, String applicationKey) {
        return this.createResource().path("user").path("application").queryParam("username", username).queryParam("applicationKey", applicationKey);
    }

    public WebResource getSearchAssignableResource(String query, String issueKey, String startAt, String maxResults) {
        WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("assignable").path("search"));
        resource = resource.queryParam("issueKey", issueKey);
        return resource;
    }

    public WebResource getMultiProjectSearchAssignableResource(String query, String projectKeys, String startAt, String maxResults) {
        WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("assignable").path("multiProjectSearch"));
        resource = resource.queryParam("projectKeys", projectKeys);
        return resource;
    }

    public WebResource getSearchViewableIssueResource(String query, String issueKey, String startAt, String maxResults) {
        WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("viewissue").path("search"));
        resource = resource.queryParam("issueKey", issueKey);
        return resource;
    }

    public WebResource getSearchResource(String query, String startAt, String maxResults, Boolean includeActive, Boolean includeInactive) {
        WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("search"));
        if (includeActive != null) {
            resource = resource.queryParam("includeActive", includeActive.toString());
        }
        if (includeInactive != null) {
            resource = resource.queryParam("includeInactive", includeInactive.toString());
        }
        return resource;
    }

    public WebResource getSearchByPermissionResource(String query, String permissions, String issueKey, String projectKey, String startAt, String maxResults) {
        WebResource resource = this.createResource().path("user").path("permission").path("search");
        resource = StringUtils.isNotBlank((String)query) ? resource.queryParam("username", query) : resource;
        resource = StringUtils.isNotBlank((String)issueKey) ? resource.queryParam("issueKey", issueKey) : resource;
        resource = StringUtils.isNotBlank((String)projectKey) ? resource.queryParam("projectKey", projectKey) : resource;
        resource = StringUtils.isNotBlank((String)startAt) ? resource.queryParam("startAt", startAt) : resource;
        resource = StringUtils.isNotBlank((String)maxResults) ? resource.queryParam("maxResults", maxResults) : resource;
        resource = resource.queryParam("permissions", permissions);
        return resource;
    }

    public WebResource getPickerResource(String query, String maxResults) {
        WebResource resource = this.createResource().path("user").path("picker");
        if (StringUtils.isNotBlank((String)query)) {
            resource = resource.queryParam("query", query);
        }
        if (StringUtils.isNotBlank((String)maxResults)) {
            resource = resource.queryParam("maxResults", maxResults);
        }
        return resource;
    }

    private WebResource applyPagingParams(String query, String startAt, String maxResults, WebResource resource) {
        resource = resource.queryParam("username", query);
        if (StringUtils.isNotBlank((String)startAt)) {
            resource = resource.queryParam("startAt", startAt);
        }
        if (StringUtils.isNotBlank((String)maxResults)) {
            resource = resource.queryParam("maxResults", maxResults);
        }
        return resource;
    }

    public Response getUserResponse(String username) {
        return this.getUserResponse(username, false);
    }

    public Response getUserResponse(String username, boolean includeDeleted) {
        return this.getResponse(this.userWithUsername(username, includeDeleted, UserClient.setOf(User.Expand.class, (Enum[])new User.Expand[0])));
    }

    public Response getUserResponseByKey(String key) {
        return this.getUserResponseByKey(key, false);
    }

    public Response getUserResponseByKey(String key, boolean includeDeleted) {
        return this.getResponse(this.userWithKey(key, includeDeleted, UserClient.setOf(User.Expand.class, (Enum[])new User.Expand[0])));
    }

    public Response getResponse(WebResource resource) {
        return this.toResponse(() -> (ClientResponse)resource.get(ClientResponse.class));
    }

    private Response postResponse(WebResource resource) {
        return this.toResponse(() -> (ClientResponse)resource.post(ClientResponse.class));
    }

    private Response deleteResponse(WebResource resource) {
        return this.toResponse(() -> (ClientResponse)resource.delete(ClientResponse.class));
    }

    private WebResource userWithUsername(String username, boolean includeDeleted, EnumSet<User.Expand> expands) {
        WebResource result = this.createResource().path("user");
        if (username != null) {
            result = result.queryParam("username", UserClient.percentEncode(username));
        }
        if (includeDeleted) {
            result = result.queryParam("includeDeleted", "true");
        }
        return this.expanded(result, expands);
    }

    private WebResource userWithKey(String key, boolean includeDeleted, EnumSet<User.Expand> expands) {
        WebResource result = this.createResource().path("user");
        if (key != null) {
            result = result.queryParam("key", UserClient.percentEncode(key));
        }
        if (includeDeleted) {
            result = result.queryParam("includeDeleted", "true");
        }
        return this.expanded(result, expands);
    }
}

